package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LabelSelectorRequirementBuilder extends io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementFluentImpl<io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement,io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementBuilder>{

    io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementFluent<?> fluent;
    Boolean validationEnabled;

    public LabelSelectorRequirementBuilder(){
            this(true);
    }
    public LabelSelectorRequirementBuilder(Boolean validationEnabled){
            this(new LabelSelectorRequirement(), validationEnabled);
    }
    public LabelSelectorRequirementBuilder(io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementFluent<?> fluent){
            this(fluent, true);
    }
    public LabelSelectorRequirementBuilder(io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LabelSelectorRequirement(), validationEnabled);
    }
    public LabelSelectorRequirementBuilder(io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement instance){
            this(fluent, instance, true);
    }
    public LabelSelectorRequirementBuilder(io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withKey(instance.getKey()); 
            fluent.withOperator(instance.getOperator()); 
            fluent.withValues(instance.getValues()); 
            this.validationEnabled = validationEnabled; 
    }
    public LabelSelectorRequirementBuilder(io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement instance){
            this(instance,true);
    }
    public LabelSelectorRequirementBuilder(io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withKey(instance.getKey()); 
            this.withOperator(instance.getOperator()); 
            this.withValues(instance.getValues()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement build(){
            LabelSelectorRequirement buildable = new LabelSelectorRequirement(fluent.getKey(),fluent.getOperator(),fluent.getValues());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LabelSelectorRequirementBuilder that = (LabelSelectorRequirementBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
