package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface JobSpecFluent<A extends JobSpecFluent<A>> extends Fluent<A>{


    public Long getActiveDeadlineSeconds();
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds);
    public Boolean hasActiveDeadlineSeconds();
    public Boolean isAutoSelector();
    public A withAutoSelector(Boolean autoSelector);
    public Boolean hasAutoSelector();
    public Integer getCompletions();
    public A withCompletions(Integer completions);
    public Boolean hasCompletions();
    public Integer getParallelism();
    public A withParallelism(Integer parallelism);
    public Boolean hasParallelism();
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 */
@Deprecated public io.fabric8.kubernetes.api.model.extensions.LabelSelector getSelector();
    public io.fabric8.kubernetes.api.model.extensions.LabelSelector buildSelector();
    public A withSelector(io.fabric8.kubernetes.api.model.extensions.LabelSelector selector);
    public Boolean hasSelector();
    public JobSpecFluent.SelectorNested<A> withNewSelector();
    public JobSpecFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.extensions.LabelSelector item);
    public JobSpecFluent.SelectorNested<A> editSelector();
    public JobSpecFluent.SelectorNested<A> editOrNewSelector();
    public JobSpecFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.extensions.LabelSelector item);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 */
@Deprecated public PodTemplateSpec getTemplate();
    public PodTemplateSpec buildTemplate();
    public A withTemplate(PodTemplateSpec template);
    public Boolean hasTemplate();
    public JobSpecFluent.TemplateNested<A> withNewTemplate();
    public JobSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public JobSpecFluent.TemplateNested<A> editTemplate();
    public JobSpecFluent.TemplateNested<A> editOrNewTemplate();
    public JobSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item);

    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluent<JobSpecFluent.SelectorNested<N>>{

        
    public N and();    public N endSelector();
}
    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateSpecFluent<JobSpecFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}


}
