package io.fabric8.kubernetes.api.model.extensions;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class DeploymentStatusFluentImpl<A extends DeploymentStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DeploymentStatusFluent<A>{

    private Integer availableReplicas;
    private Long observedGeneration;
    private Integer replicas;
    private Integer unavailableReplicas;
    private Integer updatedReplicas;

    public DeploymentStatusFluentImpl(){
    }
    public DeploymentStatusFluentImpl(DeploymentStatus instance){
            this.withAvailableReplicas(instance.getAvailableReplicas()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withReplicas(instance.getReplicas()); 
            this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
            this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    }

    public Integer getAvailableReplicas(){
            return this.availableReplicas;
    }

    public A withAvailableReplicas(Integer availableReplicas){
            this.availableReplicas=availableReplicas; return (A) this;
    }

    public Boolean hasAvailableReplicas(){
            return this.availableReplicas!=null;
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration!=null;
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas(){
            return this.replicas!=null;
    }

    public Integer getUnavailableReplicas(){
            return this.unavailableReplicas;
    }

    public A withUnavailableReplicas(Integer unavailableReplicas){
            this.unavailableReplicas=unavailableReplicas; return (A) this;
    }

    public Boolean hasUnavailableReplicas(){
            return this.unavailableReplicas!=null;
    }

    public Integer getUpdatedReplicas(){
            return this.updatedReplicas;
    }

    public A withUpdatedReplicas(Integer updatedReplicas){
            this.updatedReplicas=updatedReplicas; return (A) this;
    }

    public Boolean hasUpdatedReplicas(){
            return this.updatedReplicas!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentStatusFluentImpl that = (DeploymentStatusFluentImpl) o;
            if (availableReplicas != null ? !availableReplicas.equals(that.availableReplicas) :that.availableReplicas != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (unavailableReplicas != null ? !unavailableReplicas.equals(that.unavailableReplicas) :that.unavailableReplicas != null) return false;
            if (updatedReplicas != null ? !updatedReplicas.equals(that.updatedReplicas) :that.updatedReplicas != null) return false;
            return true;
    }




}
