package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class SignatureIssuerBuilder extends SignatureIssuerFluentImpl<SignatureIssuerBuilder> implements VisitableBuilder<SignatureIssuer,SignatureIssuerBuilder>{

    SignatureIssuerFluent<?> fluent;
    Boolean validationEnabled;

    public SignatureIssuerBuilder(){
            this(true);
    }
    public SignatureIssuerBuilder(Boolean validationEnabled){
            this(new SignatureIssuer(), validationEnabled);
    }
    public SignatureIssuerBuilder(SignatureIssuerFluent<?> fluent){
            this(fluent, true);
    }
    public SignatureIssuerBuilder(SignatureIssuerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SignatureIssuer(), validationEnabled);
    }
    public SignatureIssuerBuilder(SignatureIssuerFluent<?> fluent,SignatureIssuer instance){
            this(fluent, instance, true);
    }
    public SignatureIssuerBuilder(SignatureIssuerFluent<?> fluent,SignatureIssuer instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCommonName(instance.getCommonName()); 
            fluent.withOrganization(instance.getOrganization()); 
            this.validationEnabled = validationEnabled; 
    }
    public SignatureIssuerBuilder(SignatureIssuer instance){
            this(instance,true);
    }
    public SignatureIssuerBuilder(SignatureIssuer instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCommonName(instance.getCommonName()); 
            this.withOrganization(instance.getOrganization()); 
            this.validationEnabled = validationEnabled; 
    }

    public SignatureIssuer build(){
            SignatureIssuer buildable = new SignatureIssuer(fluent.getCommonName(),fluent.getOrganization());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SignatureIssuerBuilder that = (SignatureIssuerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
