package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class LifecycleHookBuilder extends LifecycleHookFluentImpl<LifecycleHookBuilder> implements VisitableBuilder<LifecycleHook,LifecycleHookBuilder>{

    LifecycleHookFluent<?> fluent;
    Boolean validationEnabled;

    public LifecycleHookBuilder(){
            this(true);
    }
    public LifecycleHookBuilder(Boolean validationEnabled){
            this(new LifecycleHook(), validationEnabled);
    }
    public LifecycleHookBuilder(LifecycleHookFluent<?> fluent){
            this(fluent, true);
    }
    public LifecycleHookBuilder(LifecycleHookFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LifecycleHook(), validationEnabled);
    }
    public LifecycleHookBuilder(LifecycleHookFluent<?> fluent,LifecycleHook instance){
            this(fluent, instance, true);
    }
    public LifecycleHookBuilder(LifecycleHookFluent<?> fluent,LifecycleHook instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withExecNewPod(instance.getExecNewPod()); 
            fluent.withFailurePolicy(instance.getFailurePolicy()); 
            fluent.withTagImages(instance.getTagImages()); 
            this.validationEnabled = validationEnabled; 
    }
    public LifecycleHookBuilder(LifecycleHook instance){
            this(instance,true);
    }
    public LifecycleHookBuilder(LifecycleHook instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withExecNewPod(instance.getExecNewPod()); 
            this.withFailurePolicy(instance.getFailurePolicy()); 
            this.withTagImages(instance.getTagImages()); 
            this.validationEnabled = validationEnabled; 
    }

    public LifecycleHook build(){
            LifecycleHook buildable = new LifecycleHook(fluent.getExecNewPod(),fluent.getFailurePolicy(),fluent.getTagImages());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LifecycleHookBuilder that = (LifecycleHookBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
