package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;

public class ImageStreamTagFluentImpl<A extends ImageStreamTagFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ImageStreamTagFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends TagEventCondition,?>> conditions =  new ArrayList<VisitableBuilder<? extends TagEventCondition,?>>();
    private Long generation;
    private VisitableBuilder<? extends Image,?> image;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private VisitableBuilder<? extends TagReference,?> tag;

    public ImageStreamTagFluentImpl(){
    }
    public ImageStreamTagFluentImpl(ImageStreamTag instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withConditions(instance.getConditions()); 
            this.withGeneration(instance.getGeneration()); 
            this.withImage(instance.getImage()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withTag(instance.getTag()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToConditions(TagEventCondition... items){
            for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(TagEventCondition... items){
            for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (A)this;
    }

    public List<TagEventCondition> getConditions(){
            return build(conditions);
    }

    public A withConditions(List<TagEventCondition> conditions){
            _visitables.removeAll(this.conditions);
            this.conditions.clear();
            if (conditions != null) {for (TagEventCondition item : conditions){this.addToConditions(item);}} return (A) this;
    }

    public A withConditions(TagEventCondition... conditions){
            this.conditions.clear(); if (conditions != null) {for (TagEventCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public ImageStreamTagFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public ImageStreamTagFluent.ConditionsNested<A> addNewConditionLike(TagEventCondition item){
            return new ConditionsNestedImpl(item);
    }

    public Long getGeneration(){
            return this.generation;
    }

    public A withGeneration(Long generation){
            this.generation=generation; return (A) this;
    }

    public Image getImage(){
            return this.image!=null?this.image.build():null;
    }

    public A withImage(Image image){
            _visitables.remove(this.image);
            if (image!=null){ this.image= new ImageBuilder(image); _visitables.add(this.image);} return (A) this;
    }

    public ImageStreamTagFluent.ImageNested<A> withNewImage(){
            return new ImageNestedImpl();
    }

    public ImageStreamTagFluent.ImageNested<A> withNewImageLike(Image item){
            return new ImageNestedImpl(item);
    }

    public ImageStreamTagFluent.ImageNested<A> editImage(){
            return withNewImageLike(getImage());
    }

    public ImageStreamTagFluent.ImageNested<A> editOrNewImage(){
            return withNewImageLike(getImage() != null ? getImage(): new ImageBuilder().build());
    }

    public ImageStreamTagFluent.ImageNested<A> editOrNewImageLike(Image item){
            return withNewImageLike(getImage() != null ? getImage(): item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public ImageStreamTagFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ImageStreamTagFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ImageStreamTagFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ImageStreamTagFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public ImageStreamTagFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public TagReference getTag(){
            return this.tag!=null?this.tag.build():null;
    }

    public A withTag(TagReference tag){
            _visitables.remove(this.tag);
            if (tag!=null){ this.tag= new TagReferenceBuilder(tag); _visitables.add(this.tag);} return (A) this;
    }

    public ImageStreamTagFluent.TagNested<A> withNewTag(){
            return new TagNestedImpl();
    }

    public ImageStreamTagFluent.TagNested<A> withNewTagLike(TagReference item){
            return new TagNestedImpl(item);
    }

    public ImageStreamTagFluent.TagNested<A> editTag(){
            return withNewTagLike(getTag());
    }

    public ImageStreamTagFluent.TagNested<A> editOrNewTag(){
            return withNewTagLike(getTag() != null ? getTag(): new TagReferenceBuilder().build());
    }

    public ImageStreamTagFluent.TagNested<A> editOrNewTagLike(TagReference item){
            return withNewTagLike(getTag() != null ? getTag(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageStreamTagFluentImpl that = (ImageStreamTagFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends TagEventConditionFluentImpl<ImageStreamTagFluent.ConditionsNested<N>> implements ImageStreamTagFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TagEventConditionBuilder builder;
    
            ConditionsNestedImpl(TagEventCondition item){
                    this.builder = new TagEventConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.builder = new TagEventConditionBuilder(this);
            }
    
    public N and(){
            return (N) ImageStreamTagFluentImpl.this.addToConditions(builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class ImageNestedImpl<N> extends ImageFluentImpl<ImageStreamTagFluent.ImageNested<N>> implements ImageStreamTagFluent.ImageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageBuilder builder;
    
            ImageNestedImpl(Image item){
                    this.builder = new ImageBuilder(this, item);
            }
            ImageNestedImpl(){
                    this.builder = new ImageBuilder(this);
            }
    
    public N and(){
            return (N) ImageStreamTagFluentImpl.this.withImage(builder.build());
    }
    public N endImage(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ImageStreamTagFluent.MetadataNested<N>> implements ImageStreamTagFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ImageStreamTagFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class TagNestedImpl<N> extends TagReferenceFluentImpl<ImageStreamTagFluent.TagNested<N>> implements ImageStreamTagFluent.TagNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TagReferenceBuilder builder;
    
            TagNestedImpl(TagReference item){
                    this.builder = new TagReferenceBuilder(this, item);
            }
            TagNestedImpl(){
                    this.builder = new TagReferenceBuilder(this);
            }
    
    public N and(){
            return (N) ImageStreamTagFluentImpl.this.withTag(builder.build());
    }
    public N endTag(){
            return and();
    }

}


}
