package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ClusterPolicyBindingFluent<A extends ClusterPolicyBindingFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public String getLastModified();
    public A withLastModified(String lastModified);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ClusterPolicyBindingFluent.MetadataNested<A> withNewMetadata();
    public ClusterPolicyBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ClusterPolicyBindingFluent.MetadataNested<A> editMetadata();
    public ClusterPolicyBindingFluent.MetadataNested<A> editOrNewMetadata();
    public ClusterPolicyBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public ObjectReference getPolicyRef();
    public A withPolicyRef(ObjectReference policyRef);
    public ClusterPolicyBindingFluent.PolicyRefNested<A> withNewPolicyRef();
    public ClusterPolicyBindingFluent.PolicyRefNested<A> withNewPolicyRefLike(ObjectReference item);
    public ClusterPolicyBindingFluent.PolicyRefNested<A> editPolicyRef();
    public ClusterPolicyBindingFluent.PolicyRefNested<A> editOrNewPolicyRef();
    public ClusterPolicyBindingFluent.PolicyRefNested<A> editOrNewPolicyRefLike(ObjectReference item);
    public A addToRoleBindings(NamedClusterRoleBinding... items);
    public A removeFromRoleBindings(NamedClusterRoleBinding... items);
    public List<NamedClusterRoleBinding> getRoleBindings();
    public A withRoleBindings(List<NamedClusterRoleBinding> roleBindings);
    public A withRoleBindings(NamedClusterRoleBinding... roleBindings);
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> addNewRoleBinding();
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> addNewRoleBindingLike(NamedClusterRoleBinding item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ClusterPolicyBindingFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface PolicyRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<ClusterPolicyBindingFluent.PolicyRefNested<N>>{

        
    public N and();    public N endPolicyRef();
}
    public interface RoleBindingsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedClusterRoleBindingFluent<ClusterPolicyBindingFluent.RoleBindingsNested<N>>{

        
    public N and();    public N endRoleBinding();
}


}
