package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;

public class BuildTriggerCauseFluentImpl<A extends BuildTriggerCauseFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BuildTriggerCauseFluent<A>{

    private VisitableBuilder<? extends GenericWebHookCause,?> genericWebHook;
    private VisitableBuilder<? extends GitHubWebHookCause,?> githubWebHook;
    private VisitableBuilder<? extends ImageChangeCause,?> imageChangeBuild;
    private String message;

    public BuildTriggerCauseFluentImpl(){
    }
    public BuildTriggerCauseFluentImpl(BuildTriggerCause instance){
            this.withGenericWebHook(instance.getGenericWebHook()); 
            this.withGithubWebHook(instance.getGithubWebHook()); 
            this.withImageChangeBuild(instance.getImageChangeBuild()); 
            this.withMessage(instance.getMessage()); 
    }

    public GenericWebHookCause getGenericWebHook(){
            return this.genericWebHook!=null?this.genericWebHook.build():null;
    }

    public A withGenericWebHook(GenericWebHookCause genericWebHook){
            _visitables.remove(this.genericWebHook);
            if (genericWebHook!=null){ this.genericWebHook= new GenericWebHookCauseBuilder(genericWebHook); _visitables.add(this.genericWebHook);} return (A) this;
    }

    public BuildTriggerCauseFluent.GenericWebHookNested<A> withNewGenericWebHook(){
            return new GenericWebHookNestedImpl();
    }

    public BuildTriggerCauseFluent.GenericWebHookNested<A> withNewGenericWebHookLike(GenericWebHookCause item){
            return new GenericWebHookNestedImpl(item);
    }

    public BuildTriggerCauseFluent.GenericWebHookNested<A> editGenericWebHook(){
            return withNewGenericWebHookLike(getGenericWebHook());
    }

    public BuildTriggerCauseFluent.GenericWebHookNested<A> editOrNewGenericWebHook(){
            return withNewGenericWebHookLike(getGenericWebHook() != null ? getGenericWebHook(): new GenericWebHookCauseBuilder().build());
    }

    public BuildTriggerCauseFluent.GenericWebHookNested<A> editOrNewGenericWebHookLike(GenericWebHookCause item){
            return withNewGenericWebHookLike(getGenericWebHook() != null ? getGenericWebHook(): item);
    }

    public GitHubWebHookCause getGithubWebHook(){
            return this.githubWebHook!=null?this.githubWebHook.build():null;
    }

    public A withGithubWebHook(GitHubWebHookCause githubWebHook){
            _visitables.remove(this.githubWebHook);
            if (githubWebHook!=null){ this.githubWebHook= new GitHubWebHookCauseBuilder(githubWebHook); _visitables.add(this.githubWebHook);} return (A) this;
    }

    public BuildTriggerCauseFluent.GithubWebHookNested<A> withNewGithubWebHook(){
            return new GithubWebHookNestedImpl();
    }

    public BuildTriggerCauseFluent.GithubWebHookNested<A> withNewGithubWebHookLike(GitHubWebHookCause item){
            return new GithubWebHookNestedImpl(item);
    }

    public BuildTriggerCauseFluent.GithubWebHookNested<A> editGithubWebHook(){
            return withNewGithubWebHookLike(getGithubWebHook());
    }

    public BuildTriggerCauseFluent.GithubWebHookNested<A> editOrNewGithubWebHook(){
            return withNewGithubWebHookLike(getGithubWebHook() != null ? getGithubWebHook(): new GitHubWebHookCauseBuilder().build());
    }

    public BuildTriggerCauseFluent.GithubWebHookNested<A> editOrNewGithubWebHookLike(GitHubWebHookCause item){
            return withNewGithubWebHookLike(getGithubWebHook() != null ? getGithubWebHook(): item);
    }

    public ImageChangeCause getImageChangeBuild(){
            return this.imageChangeBuild!=null?this.imageChangeBuild.build():null;
    }

    public A withImageChangeBuild(ImageChangeCause imageChangeBuild){
            _visitables.remove(this.imageChangeBuild);
            if (imageChangeBuild!=null){ this.imageChangeBuild= new ImageChangeCauseBuilder(imageChangeBuild); _visitables.add(this.imageChangeBuild);} return (A) this;
    }

    public BuildTriggerCauseFluent.ImageChangeBuildNested<A> withNewImageChangeBuild(){
            return new ImageChangeBuildNestedImpl();
    }

    public BuildTriggerCauseFluent.ImageChangeBuildNested<A> withNewImageChangeBuildLike(ImageChangeCause item){
            return new ImageChangeBuildNestedImpl(item);
    }

    public BuildTriggerCauseFluent.ImageChangeBuildNested<A> editImageChangeBuild(){
            return withNewImageChangeBuildLike(getImageChangeBuild());
    }

    public BuildTriggerCauseFluent.ImageChangeBuildNested<A> editOrNewImageChangeBuild(){
            return withNewImageChangeBuildLike(getImageChangeBuild() != null ? getImageChangeBuild(): new ImageChangeCauseBuilder().build());
    }

    public BuildTriggerCauseFluent.ImageChangeBuildNested<A> editOrNewImageChangeBuildLike(ImageChangeCause item){
            return withNewImageChangeBuildLike(getImageChangeBuild() != null ? getImageChangeBuild(): item);
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildTriggerCauseFluentImpl that = (BuildTriggerCauseFluentImpl) o;
            if (genericWebHook != null ? !genericWebHook.equals(that.genericWebHook) :that.genericWebHook != null) return false;
            if (githubWebHook != null ? !githubWebHook.equals(that.githubWebHook) :that.githubWebHook != null) return false;
            if (imageChangeBuild != null ? !imageChangeBuild.equals(that.imageChangeBuild) :that.imageChangeBuild != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            return true;
    }


    public class GenericWebHookNestedImpl<N> extends GenericWebHookCauseFluentImpl<BuildTriggerCauseFluent.GenericWebHookNested<N>> implements BuildTriggerCauseFluent.GenericWebHookNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GenericWebHookCauseBuilder builder;
    
            GenericWebHookNestedImpl(GenericWebHookCause item){
                    this.builder = new GenericWebHookCauseBuilder(this, item);
            }
            GenericWebHookNestedImpl(){
                    this.builder = new GenericWebHookCauseBuilder(this);
            }
    
    public N and(){
            return (N) BuildTriggerCauseFluentImpl.this.withGenericWebHook(builder.build());
    }
    public N endGenericWebHook(){
            return and();
    }

}
    public class GithubWebHookNestedImpl<N> extends GitHubWebHookCauseFluentImpl<BuildTriggerCauseFluent.GithubWebHookNested<N>> implements BuildTriggerCauseFluent.GithubWebHookNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GitHubWebHookCauseBuilder builder;
    
            GithubWebHookNestedImpl(GitHubWebHookCause item){
                    this.builder = new GitHubWebHookCauseBuilder(this, item);
            }
            GithubWebHookNestedImpl(){
                    this.builder = new GitHubWebHookCauseBuilder(this);
            }
    
    public N and(){
            return (N) BuildTriggerCauseFluentImpl.this.withGithubWebHook(builder.build());
    }
    public N endGithubWebHook(){
            return and();
    }

}
    public class ImageChangeBuildNestedImpl<N> extends ImageChangeCauseFluentImpl<BuildTriggerCauseFluent.ImageChangeBuildNested<N>> implements BuildTriggerCauseFluent.ImageChangeBuildNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageChangeCauseBuilder builder;
    
            ImageChangeBuildNestedImpl(ImageChangeCause item){
                    this.builder = new ImageChangeCauseBuilder(this, item);
            }
            ImageChangeBuildNestedImpl(){
                    this.builder = new ImageChangeCauseBuilder(this);
            }
    
    public N and(){
            return (N) BuildTriggerCauseFluentImpl.this.withImageChangeBuild(builder.build());
    }
    public N endImageChangeBuild(){
            return and();
    }

}


}
