package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public class LabelSelectorFluentImpl<A extends io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluent<A>{

    private List<VisitableBuilder<? extends io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement,?>> matchExpressions =  new ArrayList<VisitableBuilder<? extends io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement,?>>();
    private Map<String,String> matchLabels = new LinkedHashMap<String,String>();

    public LabelSelectorFluentImpl(){
    }
    public LabelSelectorFluentImpl(io.fabric8.kubernetes.api.model.extensions.LabelSelector instance){
            this.withMatchExpressions(instance.getMatchExpressions()); 
            this.withMatchLabels(instance.getMatchLabels()); 
    }

    public A addToMatchExpressions(io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement... items){
            for (io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement item : items) {io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementBuilder builder = new io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementBuilder(item);_visitables.add(builder);this.matchExpressions.add(builder);} return (A)this;
    }

    public A removeFromMatchExpressions(io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement... items){
            for (io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement item : items) {io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementBuilder builder = new io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementBuilder(item);_visitables.remove(builder);this.matchExpressions.remove(builder);} return (A)this;
    }

    public List<io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement> getMatchExpressions(){
            return build(matchExpressions);
    }

    public A withMatchExpressions(List<io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement> matchExpressions){
            _visitables.removeAll(this.matchExpressions);
            this.matchExpressions.clear();
            if (matchExpressions != null) {for (io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement item : matchExpressions){this.addToMatchExpressions(item);}} return (A) this;
    }

    public A withMatchExpressions(io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement... matchExpressions){
            this.matchExpressions.clear(); if (matchExpressions != null) {for (io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement item :matchExpressions){ this.addToMatchExpressions(item);}} return (A) this;
    }

    public LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpression(){
            return new MatchExpressionsNestedImpl();
    }

    public LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpressionLike(io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement item){
            return new MatchExpressionsNestedImpl(item);
    }

    public A addToMatchLabels(String key,String value){
            if(key != null && value != null) {this.matchLabels.put(key, value);} return (A)this;
    }

    public A addToMatchLabels(Map<String,String> map){
            if(map != null) { this.matchLabels.putAll(map);} return (A)this;
    }

    public A removeFromMatchLabels(String key){
            if(key != null) {this.matchLabels.remove(key);} return (A)this;
    }

    public A removeFromMatchLabels(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.matchLabels.remove(key);}} return (A)this;
    }

    public Map<String,String> getMatchLabels(){
            return this.matchLabels;
    }

    public A withMatchLabels(Map<String,String> matchLabels){
            this.matchLabels.clear();
            if (matchLabels != null) {this.matchLabels.putAll(matchLabels);} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LabelSelectorFluentImpl that = (LabelSelectorFluentImpl) o;
            if (matchExpressions != null ? !matchExpressions.equals(that.matchExpressions) :that.matchExpressions != null) return false;
            if (matchLabels != null ? !matchLabels.equals(that.matchLabels) :that.matchLabels != null) return false;
            return true;
    }


    public class MatchExpressionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementFluentImpl<LabelSelectorFluent.MatchExpressionsNested<N>> implements LabelSelectorFluent.MatchExpressionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementBuilder builder;
    
            MatchExpressionsNestedImpl(io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement item){
                    this.builder = new io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementBuilder(this, item);
            }
            MatchExpressionsNestedImpl(){
                    this.builder = new io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementBuilder(this);
            }
    
    public N and(){
            return (N) LabelSelectorFluentImpl.this.addToMatchExpressions(builder.build());
    }
    public N endMatchExpression(){
            return and();
    }

}


}
