package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface DeploymentFluent<A extends DeploymentFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public DeploymentFluent.MetadataNested<A> withNewMetadata();
    public DeploymentFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public DeploymentFluent.MetadataNested<A> editMetadata();
    public DeploymentFluent.MetadataNested<A> editOrNewMetadata();
    public DeploymentFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public DeploymentSpec getSpec();
    public A withSpec(DeploymentSpec spec);
    public DeploymentFluent.SpecNested<A> withNewSpec();
    public DeploymentFluent.SpecNested<A> withNewSpecLike(DeploymentSpec item);
    public DeploymentFluent.SpecNested<A> editSpec();
    public DeploymentFluent.SpecNested<A> editOrNewSpec();
    public DeploymentFluent.SpecNested<A> editOrNewSpecLike(DeploymentSpec item);
    public DeploymentStatus getStatus();
    public A withStatus(DeploymentStatus status);
    public DeploymentFluent.StatusNested<A> withNewStatus();
    public DeploymentFluent.StatusNested<A> withNewStatusLike(DeploymentStatus item);
    public DeploymentFluent.StatusNested<A> editStatus();
    public DeploymentFluent.StatusNested<A> editOrNewStatus();
    public DeploymentFluent.StatusNested<A> editOrNewStatusLike(DeploymentStatus item);
    public A withNewStatus(Integer availableReplicas,Long observedGeneration,Integer replicas,Integer unavailableReplicas,Integer updatedReplicas);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<DeploymentFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentSpecFluent<DeploymentFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentStatusFluent<DeploymentFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
