package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface DaemonSetFluent<A extends DaemonSetFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public DaemonSetFluent.MetadataNested<A> withNewMetadata();
    public DaemonSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public DaemonSetFluent.MetadataNested<A> editMetadata();
    public DaemonSetFluent.MetadataNested<A> editOrNewMetadata();
    public DaemonSetFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public DaemonSetSpec getSpec();
    public A withSpec(DaemonSetSpec spec);
    public DaemonSetFluent.SpecNested<A> withNewSpec();
    public DaemonSetFluent.SpecNested<A> withNewSpecLike(DaemonSetSpec item);
    public DaemonSetFluent.SpecNested<A> editSpec();
    public DaemonSetFluent.SpecNested<A> editOrNewSpec();
    public DaemonSetFluent.SpecNested<A> editOrNewSpecLike(DaemonSetSpec item);
    public DaemonSetStatus getStatus();
    public A withStatus(DaemonSetStatus status);
    public DaemonSetFluent.StatusNested<A> withNewStatus();
    public DaemonSetFluent.StatusNested<A> withNewStatusLike(DaemonSetStatus item);
    public DaemonSetFluent.StatusNested<A> editStatus();
    public DaemonSetFluent.StatusNested<A> editOrNewStatus();
    public DaemonSetFluent.StatusNested<A> editOrNewStatusLike(DaemonSetStatus item);
    public A withNewStatus(Integer currentNumberScheduled,Integer desiredNumberScheduled,Integer numberMisscheduled);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<DaemonSetFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DaemonSetSpecFluent<DaemonSetFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DaemonSetStatusFluent<DaemonSetFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
