package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class VsphereVirtualDiskVolumeSourceBuilder extends VsphereVirtualDiskVolumeSourceFluentImpl<VsphereVirtualDiskVolumeSourceBuilder> implements VisitableBuilder<VsphereVirtualDiskVolumeSource,VsphereVirtualDiskVolumeSourceBuilder>{

    VsphereVirtualDiskVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public VsphereVirtualDiskVolumeSourceBuilder(){
            this(true);
    }
    public VsphereVirtualDiskVolumeSourceBuilder(Boolean validationEnabled){
            this(new VsphereVirtualDiskVolumeSource(), validationEnabled);
    }
    public VsphereVirtualDiskVolumeSourceBuilder(VsphereVirtualDiskVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public VsphereVirtualDiskVolumeSourceBuilder(VsphereVirtualDiskVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new VsphereVirtualDiskVolumeSource(), validationEnabled);
    }
    public VsphereVirtualDiskVolumeSourceBuilder(VsphereVirtualDiskVolumeSourceFluent<?> fluent,VsphereVirtualDiskVolumeSource instance){
            this(fluent, instance, true);
    }
    public VsphereVirtualDiskVolumeSourceBuilder(VsphereVirtualDiskVolumeSourceFluent<?> fluent,VsphereVirtualDiskVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFsType(instance.getFsType()); 
            fluent.withVolumePath(instance.getVolumePath()); 
            this.validationEnabled = validationEnabled; 
    }
    public VsphereVirtualDiskVolumeSourceBuilder(VsphereVirtualDiskVolumeSource instance){
            this(instance,true);
    }
    public VsphereVirtualDiskVolumeSourceBuilder(VsphereVirtualDiskVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFsType(instance.getFsType()); 
            this.withVolumePath(instance.getVolumePath()); 
            this.validationEnabled = validationEnabled; 
    }

    public VsphereVirtualDiskVolumeSource build(){
            VsphereVirtualDiskVolumeSource buildable = new VsphereVirtualDiskVolumeSource(fluent.getFsType(),fluent.getVolumePath());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VsphereVirtualDiskVolumeSourceBuilder that = (VsphereVirtualDiskVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
