package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class OwnerReferenceFluentImpl<A extends OwnerReferenceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OwnerReferenceFluent<A>{

    private String apiVersion;
    private Boolean controller;
    private String kind;
    private String name;
    private String uid;

    public OwnerReferenceFluentImpl(){
    }
    public OwnerReferenceFluentImpl(OwnerReference instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withController(instance.getController()); 
            this.withKind(instance.getKind()); 
            this.withName(instance.getName()); 
            this.withUid(instance.getUid()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean isController(){
            return this.controller;
    }

    public A withController(Boolean controller){
            this.controller=controller; return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public String getUid(){
            return this.uid;
    }

    public A withUid(String uid){
            this.uid=uid; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OwnerReferenceFluentImpl that = (OwnerReferenceFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (controller != null ? !controller.equals(that.controller) :that.controller != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
            return true;
    }




}
