package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface EndpointSubsetFluent<A extends EndpointSubsetFluent<A>> extends Fluent<A>{


    public A addToAddresses(EndpointAddress... items);
    public A removeFromAddresses(EndpointAddress... items);
    public List<EndpointAddress> getAddresses();
    public A withAddresses(List<EndpointAddress> addresses);
    public A withAddresses(EndpointAddress... addresses);
    public EndpointSubsetFluent.AddressesNested<A> addNewAddress();
    public EndpointSubsetFluent.AddressesNested<A> addNewAddressLike(EndpointAddress item);
    public A addToNotReadyAddresses(EndpointAddress... items);
    public A removeFromNotReadyAddresses(EndpointAddress... items);
    public List<EndpointAddress> getNotReadyAddresses();
    public A withNotReadyAddresses(List<EndpointAddress> notReadyAddresses);
    public A withNotReadyAddresses(EndpointAddress... notReadyAddresses);
    public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddress();
    public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddressLike(EndpointAddress item);
    public A addToPorts(EndpointPort... items);
    public A removeFromPorts(EndpointPort... items);
    public List<EndpointPort> getPorts();
    public A withPorts(List<EndpointPort> ports);
    public A withPorts(EndpointPort... ports);
    public EndpointSubsetFluent.PortsNested<A> addNewPort();
    public EndpointSubsetFluent.PortsNested<A> addNewPortLike(EndpointPort item);
    public A addNewPort(String name,Integer port,String protocol);

    public interface AddressesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointAddressFluent<EndpointSubsetFluent.AddressesNested<N>>{

        
    public N and();    public N endAddress();
}
    public interface NotReadyAddressesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointAddressFluent<EndpointSubsetFluent.NotReadyAddressesNested<N>>{

        
    public N and();    public N endNotReadyAddress();
}
    public interface PortsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointPortFluent<EndpointSubsetFluent.PortsNested<N>>{

        
    public N and();    public N endPort();
}


}
