package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class DownwardAPIVolumeSourceFluentImpl<A extends DownwardAPIVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DownwardAPIVolumeSourceFluent<A>{

    private List<VisitableBuilder<? extends DownwardAPIVolumeFile,?>> items =  new ArrayList<VisitableBuilder<? extends DownwardAPIVolumeFile,?>>();

    public DownwardAPIVolumeSourceFluentImpl(){
    }
    public DownwardAPIVolumeSourceFluentImpl(DownwardAPIVolumeSource instance){
            this.withItems(instance.getItems()); 
    }

    public A addToItems(DownwardAPIVolumeFile... items){
            for (DownwardAPIVolumeFile item : items) {DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(DownwardAPIVolumeFile... items){
            for (DownwardAPIVolumeFile item : items) {DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<DownwardAPIVolumeFile> getItems(){
            return build(items);
    }

    public A withItems(List<DownwardAPIVolumeFile> items){
            _visitables.removeAll(this.items);
            this.items.clear();
            if (items != null) {for (DownwardAPIVolumeFile item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(DownwardAPIVolumeFile... items){
            this.items.clear(); if (items != null) {for (DownwardAPIVolumeFile item :items){ this.addToItems(item);}} return (A) this;
    }

    public DownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public DownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItemLike(DownwardAPIVolumeFile item){
            return new ItemsNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DownwardAPIVolumeSourceFluentImpl that = (DownwardAPIVolumeSourceFluentImpl) o;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends DownwardAPIVolumeFileFluentImpl<DownwardAPIVolumeSourceFluent.ItemsNested<N>> implements DownwardAPIVolumeSourceFluent.ItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DownwardAPIVolumeFileBuilder builder;
    
            ItemsNestedImpl(DownwardAPIVolumeFile item){
                    this.builder = new DownwardAPIVolumeFileBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.builder = new DownwardAPIVolumeFileBuilder(this);
            }
    
    public N and(){
            return (N) DownwardAPIVolumeSourceFluentImpl.this.addToItems(builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
