package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class PolicyBindingBuilder extends PolicyBindingFluentImpl<PolicyBindingBuilder> implements VisitableBuilder<PolicyBinding,PolicyBindingBuilder>{

    PolicyBindingFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyBindingBuilder(){
            this(true);
    }
    public PolicyBindingBuilder(Boolean validationEnabled){
            this(new PolicyBinding(), validationEnabled);
    }
    public PolicyBindingBuilder(PolicyBindingFluent<?> fluent){
            this(fluent, true);
    }
    public PolicyBindingBuilder(PolicyBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PolicyBinding(), validationEnabled);
    }
    public PolicyBindingBuilder(PolicyBindingFluent<?> fluent,PolicyBinding instance){
            this(fluent, instance, true);
    }
    public PolicyBindingBuilder(PolicyBindingFluent<?> fluent,PolicyBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withLastModified(instance.getLastModified()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withPolicyRef(instance.getPolicyRef()); 
            fluent.withRoleBindings(instance.getRoleBindings()); 
            this.validationEnabled = validationEnabled; 
    }
    public PolicyBindingBuilder(PolicyBinding instance){
            this(instance,true);
    }
    public PolicyBindingBuilder(PolicyBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withLastModified(instance.getLastModified()); 
            this.withMetadata(instance.getMetadata()); 
            this.withPolicyRef(instance.getPolicyRef()); 
            this.withRoleBindings(instance.getRoleBindings()); 
            this.validationEnabled = validationEnabled; 
    }

    public PolicyBinding build(){
            PolicyBinding buildable = new PolicyBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getLastModified(),fluent.getMetadata(),fluent.getPolicyRef(),fluent.getRoleBindings());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyBindingBuilder that = (PolicyBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
