package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class OAuthClientBuilder extends OAuthClientFluentImpl<OAuthClientBuilder> implements VisitableBuilder<OAuthClient,OAuthClientBuilder>{

    OAuthClientFluent<?> fluent;
    Boolean validationEnabled;

    public OAuthClientBuilder(){
            this(true);
    }
    public OAuthClientBuilder(Boolean validationEnabled){
            this(new OAuthClient(), validationEnabled);
    }
    public OAuthClientBuilder(OAuthClientFluent<?> fluent){
            this(fluent, true);
    }
    public OAuthClientBuilder(OAuthClientFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OAuthClient(), validationEnabled);
    }
    public OAuthClientBuilder(OAuthClientFluent<?> fluent,OAuthClient instance){
            this(fluent, instance, true);
    }
    public OAuthClientBuilder(OAuthClientFluent<?> fluent,OAuthClient instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAdditionalSecrets(instance.getAdditionalSecrets()); 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withGrantMethod(instance.getGrantMethod()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withRedirectURIs(instance.getRedirectURIs()); 
            fluent.withRespondWithChallenges(instance.getRespondWithChallenges()); 
            fluent.withScopeRestrictions(instance.getScopeRestrictions()); 
            fluent.withSecret(instance.getSecret()); 
            this.validationEnabled = validationEnabled; 
    }
    public OAuthClientBuilder(OAuthClient instance){
            this(instance,true);
    }
    public OAuthClientBuilder(OAuthClient instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAdditionalSecrets(instance.getAdditionalSecrets()); 
            this.withApiVersion(instance.getApiVersion()); 
            this.withGrantMethod(instance.getGrantMethod()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRedirectURIs(instance.getRedirectURIs()); 
            this.withRespondWithChallenges(instance.getRespondWithChallenges()); 
            this.withScopeRestrictions(instance.getScopeRestrictions()); 
            this.withSecret(instance.getSecret()); 
            this.validationEnabled = validationEnabled; 
    }

    public OAuthClient build(){
            OAuthClient buildable = new OAuthClient(fluent.getAdditionalSecrets(),fluent.getApiVersion(),fluent.getGrantMethod(),fluent.getKind(),fluent.getMetadata(),fluent.getRedirectURIs(),fluent.isRespondWithChallenges(),fluent.getScopeRestrictions(),fluent.getSecret());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OAuthClientBuilder that = (OAuthClientBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
