package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public class ImageSignatureFluentImpl<A extends ImageSignatureFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ImageSignatureFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends SignatureCondition,?>> conditions =  new ArrayList<VisitableBuilder<? extends SignatureCondition,?>>();
    private String content;
    private String created;
    private String imageIdentity;
    private VisitableBuilder<? extends SignatureIssuer,?> issuedBy;
    private VisitableBuilder<? extends SignatureSubject,?> issuedTo;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private Map<String,String> signedClaims = new LinkedHashMap<String,String>();
    private String type;

    public ImageSignatureFluentImpl(){
    }
    public ImageSignatureFluentImpl(ImageSignature instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withConditions(instance.getConditions()); 
            this.withContent(instance.getContent()); 
            this.withCreated(instance.getCreated()); 
            this.withImageIdentity(instance.getImageIdentity()); 
            this.withIssuedBy(instance.getIssuedBy()); 
            this.withIssuedTo(instance.getIssuedTo()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSignedClaims(instance.getSignedClaims()); 
            this.withType(instance.getType()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToConditions(SignatureCondition... items){
            for (SignatureCondition item : items) {SignatureConditionBuilder builder = new SignatureConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(SignatureCondition... items){
            for (SignatureCondition item : items) {SignatureConditionBuilder builder = new SignatureConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (A)this;
    }

    public List<SignatureCondition> getConditions(){
            return build(conditions);
    }

    public A withConditions(List<SignatureCondition> conditions){
            _visitables.removeAll(this.conditions);
            this.conditions.clear();
            if (conditions != null) {for (SignatureCondition item : conditions){this.addToConditions(item);}} return (A) this;
    }

    public A withConditions(SignatureCondition... conditions){
            this.conditions.clear(); if (conditions != null) {for (SignatureCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public ImageSignatureFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public ImageSignatureFluent.ConditionsNested<A> addNewConditionLike(SignatureCondition item){
            return new ConditionsNestedImpl(item);
    }

    public String getContent(){
            return this.content;
    }

    public A withContent(String content){
            this.content=content; return (A) this;
    }

    public String getCreated(){
            return this.created;
    }

    public A withCreated(String created){
            this.created=created; return (A) this;
    }

    public String getImageIdentity(){
            return this.imageIdentity;
    }

    public A withImageIdentity(String imageIdentity){
            this.imageIdentity=imageIdentity; return (A) this;
    }

    public SignatureIssuer getIssuedBy(){
            return this.issuedBy!=null?this.issuedBy.build():null;
    }

    public A withIssuedBy(SignatureIssuer issuedBy){
            _visitables.remove(this.issuedBy);
            if (issuedBy!=null){ this.issuedBy= new SignatureIssuerBuilder(issuedBy); _visitables.add(this.issuedBy);} return (A) this;
    }

    public ImageSignatureFluent.IssuedByNested<A> withNewIssuedBy(){
            return new IssuedByNestedImpl();
    }

    public ImageSignatureFluent.IssuedByNested<A> withNewIssuedByLike(SignatureIssuer item){
            return new IssuedByNestedImpl(item);
    }

    public ImageSignatureFluent.IssuedByNested<A> editIssuedBy(){
            return withNewIssuedByLike(getIssuedBy());
    }

    public ImageSignatureFluent.IssuedByNested<A> editOrNewIssuedBy(){
            return withNewIssuedByLike(getIssuedBy() != null ? getIssuedBy(): new SignatureIssuerBuilder().build());
    }

    public ImageSignatureFluent.IssuedByNested<A> editOrNewIssuedByLike(SignatureIssuer item){
            return withNewIssuedByLike(getIssuedBy() != null ? getIssuedBy(): item);
    }

    public A withNewIssuedBy(String commonName,String organization){
            return (A)withIssuedBy(new SignatureIssuer(commonName, organization));
    }

    public SignatureSubject getIssuedTo(){
            return this.issuedTo!=null?this.issuedTo.build():null;
    }

    public A withIssuedTo(SignatureSubject issuedTo){
            _visitables.remove(this.issuedTo);
            if (issuedTo!=null){ this.issuedTo= new SignatureSubjectBuilder(issuedTo); _visitables.add(this.issuedTo);} return (A) this;
    }

    public ImageSignatureFluent.IssuedToNested<A> withNewIssuedTo(){
            return new IssuedToNestedImpl();
    }

    public ImageSignatureFluent.IssuedToNested<A> withNewIssuedToLike(SignatureSubject item){
            return new IssuedToNestedImpl(item);
    }

    public ImageSignatureFluent.IssuedToNested<A> editIssuedTo(){
            return withNewIssuedToLike(getIssuedTo());
    }

    public ImageSignatureFluent.IssuedToNested<A> editOrNewIssuedTo(){
            return withNewIssuedToLike(getIssuedTo() != null ? getIssuedTo(): new SignatureSubjectBuilder().build());
    }

    public ImageSignatureFluent.IssuedToNested<A> editOrNewIssuedToLike(SignatureSubject item){
            return withNewIssuedToLike(getIssuedTo() != null ? getIssuedTo(): item);
    }

    public A withNewIssuedTo(String commonName,String organization,String publicKeyID){
            return (A)withIssuedTo(new SignatureSubject(commonName, organization, publicKeyID));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public ImageSignatureFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ImageSignatureFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ImageSignatureFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ImageSignatureFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public ImageSignatureFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToSignedClaims(String key,String value){
            if(key != null && value != null) {this.signedClaims.put(key, value);} return (A)this;
    }

    public A addToSignedClaims(Map<String,String> map){
            if(map != null) { this.signedClaims.putAll(map);} return (A)this;
    }

    public A removeFromSignedClaims(String key){
            if(key != null) {this.signedClaims.remove(key);} return (A)this;
    }

    public A removeFromSignedClaims(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.signedClaims.remove(key);}} return (A)this;
    }

    public Map<String,String> getSignedClaims(){
            return this.signedClaims;
    }

    public A withSignedClaims(Map<String,String> signedClaims){
            this.signedClaims.clear();
            if (signedClaims != null) {this.signedClaims.putAll(signedClaims);} return (A) this;
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageSignatureFluentImpl that = (ImageSignatureFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (content != null ? !content.equals(that.content) :that.content != null) return false;
            if (created != null ? !created.equals(that.created) :that.created != null) return false;
            if (imageIdentity != null ? !imageIdentity.equals(that.imageIdentity) :that.imageIdentity != null) return false;
            if (issuedBy != null ? !issuedBy.equals(that.issuedBy) :that.issuedBy != null) return false;
            if (issuedTo != null ? !issuedTo.equals(that.issuedTo) :that.issuedTo != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (signedClaims != null ? !signedClaims.equals(that.signedClaims) :that.signedClaims != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends SignatureConditionFluentImpl<ImageSignatureFluent.ConditionsNested<N>> implements ImageSignatureFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SignatureConditionBuilder builder;
    
            ConditionsNestedImpl(SignatureCondition item){
                    this.builder = new SignatureConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.builder = new SignatureConditionBuilder(this);
            }
    
    public N and(){
            return (N) ImageSignatureFluentImpl.this.addToConditions(builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class IssuedByNestedImpl<N> extends SignatureIssuerFluentImpl<ImageSignatureFluent.IssuedByNested<N>> implements ImageSignatureFluent.IssuedByNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SignatureIssuerBuilder builder;
    
            IssuedByNestedImpl(SignatureIssuer item){
                    this.builder = new SignatureIssuerBuilder(this, item);
            }
            IssuedByNestedImpl(){
                    this.builder = new SignatureIssuerBuilder(this);
            }
    
    public N and(){
            return (N) ImageSignatureFluentImpl.this.withIssuedBy(builder.build());
    }
    public N endIssuedBy(){
            return and();
    }

}
    public class IssuedToNestedImpl<N> extends SignatureSubjectFluentImpl<ImageSignatureFluent.IssuedToNested<N>> implements ImageSignatureFluent.IssuedToNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SignatureSubjectBuilder builder;
    
            IssuedToNestedImpl(SignatureSubject item){
                    this.builder = new SignatureSubjectBuilder(this, item);
            }
            IssuedToNestedImpl(){
                    this.builder = new SignatureSubjectBuilder(this);
            }
    
    public N and(){
            return (N) ImageSignatureFluentImpl.this.withIssuedTo(builder.build());
    }
    public N endIssuedTo(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ImageSignatureFluent.MetadataNested<N>> implements ImageSignatureFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ImageSignatureFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
