package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface IdentityFluent<A extends IdentityFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToExtra(String key,String value);
    public A addToExtra(Map<String,String> map);
    public A removeFromExtra(String key);
    public A removeFromExtra(Map<String,String> map);
    public Map<String,String> getExtra();
    public A withExtra(Map<String,String> extra);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public IdentityFluent.MetadataNested<A> withNewMetadata();
    public IdentityFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public IdentityFluent.MetadataNested<A> editMetadata();
    public IdentityFluent.MetadataNested<A> editOrNewMetadata();
    public IdentityFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public String getProviderName();
    public A withProviderName(String providerName);
    public String getProviderUserName();
    public A withProviderUserName(String providerUserName);
    public ObjectReference getUser();
    public A withUser(ObjectReference user);
    public IdentityFluent.UserNested<A> withNewUser();
    public IdentityFluent.UserNested<A> withNewUserLike(ObjectReference item);
    public IdentityFluent.UserNested<A> editUser();
    public IdentityFluent.UserNested<A> editOrNewUser();
    public IdentityFluent.UserNested<A> editOrNewUserLike(ObjectReference item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<IdentityFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface UserNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<IdentityFluent.UserNested<N>>{

        
    public N and();    public N endUser();
}


}
