package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface BuildSourceFluent<A extends BuildSourceFluent<A>> extends Fluent<A>{


    public BinaryBuildSource getBinary();
    public A withBinary(BinaryBuildSource binary);
    public BuildSourceFluent.BinaryNested<A> withNewBinary();
    public BuildSourceFluent.BinaryNested<A> withNewBinaryLike(BinaryBuildSource item);
    public BuildSourceFluent.BinaryNested<A> editBinary();
    public BuildSourceFluent.BinaryNested<A> editOrNewBinary();
    public BuildSourceFluent.BinaryNested<A> editOrNewBinaryLike(BinaryBuildSource item);
    public A withNewBinary(String asFile);
    public String getContextDir();
    public A withContextDir(String contextDir);
    public String getDockerfile();
    public A withDockerfile(String dockerfile);
    public GitBuildSource getGit();
    public A withGit(GitBuildSource git);
    public BuildSourceFluent.GitNested<A> withNewGit();
    public BuildSourceFluent.GitNested<A> withNewGitLike(GitBuildSource item);
    public BuildSourceFluent.GitNested<A> editGit();
    public BuildSourceFluent.GitNested<A> editOrNewGit();
    public BuildSourceFluent.GitNested<A> editOrNewGitLike(GitBuildSource item);
    public A withNewGit(String httpProxy,String httpsProxy,String ref,String uri);
    public A addToImages(ImageSource... items);
    public A removeFromImages(ImageSource... items);
    public List<ImageSource> getImages();
    public A withImages(List<ImageSource> images);
    public A withImages(ImageSource... images);
    public BuildSourceFluent.ImagesNested<A> addNewImage();
    public BuildSourceFluent.ImagesNested<A> addNewImageLike(ImageSource item);
    public A addToSecrets(SecretBuildSource... items);
    public A removeFromSecrets(SecretBuildSource... items);
    public List<SecretBuildSource> getSecrets();
    public A withSecrets(List<SecretBuildSource> secrets);
    public A withSecrets(SecretBuildSource... secrets);
    public BuildSourceFluent.SecretsNested<A> addNewSecret();
    public BuildSourceFluent.SecretsNested<A> addNewSecretLike(SecretBuildSource item);
    public LocalObjectReference getSourceSecret();
    public A withSourceSecret(LocalObjectReference sourceSecret);
    public BuildSourceFluent.SourceSecretNested<A> withNewSourceSecret();
    public BuildSourceFluent.SourceSecretNested<A> withNewSourceSecretLike(LocalObjectReference item);
    public BuildSourceFluent.SourceSecretNested<A> editSourceSecret();
    public BuildSourceFluent.SourceSecretNested<A> editOrNewSourceSecret();
    public BuildSourceFluent.SourceSecretNested<A> editOrNewSourceSecretLike(LocalObjectReference item);
    public A withNewSourceSecret(String name);
    public String getType();
    public A withType(String type);

    public interface BinaryNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BinaryBuildSourceFluent<BuildSourceFluent.BinaryNested<N>>{

        
    public N and();    public N endBinary();
}
    public interface GitNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GitBuildSourceFluent<BuildSourceFluent.GitNested<N>>{

        
    public N and();    public N endGit();
}
    public interface ImagesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageSourceFluent<BuildSourceFluent.ImagesNested<N>>{

        
    public N and();    public N endImage();
}
    public interface SecretsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecretBuildSourceFluent<BuildSourceFluent.SecretsNested<N>>{

        
    public N and();    public N endSecret();
}
    public interface SourceSecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<BuildSourceFluent.SourceSecretNested<N>>{

        
    public N and();    public N endSourceSecret();
}


}
