package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class PetSetBuilder extends PetSetFluentImpl<PetSetBuilder> implements VisitableBuilder<PetSet,PetSetBuilder>{

    PetSetFluent<?> fluent;
    Boolean validationEnabled;

    public PetSetBuilder(){
            this(true);
    }
    public PetSetBuilder(Boolean validationEnabled){
            this(new PetSet(), validationEnabled);
    }
    public PetSetBuilder(PetSetFluent<?> fluent){
            this(fluent, true);
    }
    public PetSetBuilder(PetSetFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PetSet(), validationEnabled);
    }
    public PetSetBuilder(PetSetFluent<?> fluent,PetSet instance){
            this(fluent, instance, true);
    }
    public PetSetBuilder(PetSetFluent<?> fluent,PetSet instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public PetSetBuilder(PetSet instance){
            this(instance,true);
    }
    public PetSetBuilder(PetSet instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public PetSet build(){
            PetSet buildable = new PetSet(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PetSetBuilder that = (PetSetBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
