package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface DeploymentSpecFluent<A extends DeploymentSpecFluent<A>> extends Fluent<A>{


    public Integer getMinReadySeconds();
    public A withMinReadySeconds(Integer minReadySeconds);
    public Boolean isPaused();
    public A withPaused(Boolean paused);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Integer getRevisionHistoryLimit();
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit);
    public RollbackConfig getRollbackTo();
    public A withRollbackTo(RollbackConfig rollbackTo);
    public DeploymentSpecFluent.RollbackToNested<A> withNewRollbackTo();
    public DeploymentSpecFluent.RollbackToNested<A> withNewRollbackToLike(RollbackConfig item);
    public DeploymentSpecFluent.RollbackToNested<A> editRollbackTo();
    public DeploymentSpecFluent.RollbackToNested<A> editOrNewRollbackTo();
    public DeploymentSpecFluent.RollbackToNested<A> editOrNewRollbackToLike(RollbackConfig item);
    public A withNewRollbackTo(Long revision);
    public io.fabric8.kubernetes.api.model.extensions.LabelSelector getSelector();
    public A withSelector(io.fabric8.kubernetes.api.model.extensions.LabelSelector selector);
    public DeploymentSpecFluent.SelectorNested<A> withNewSelector();
    public DeploymentSpecFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.extensions.LabelSelector item);
    public DeploymentSpecFluent.SelectorNested<A> editSelector();
    public DeploymentSpecFluent.SelectorNested<A> editOrNewSelector();
    public DeploymentSpecFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.extensions.LabelSelector item);
    public DeploymentStrategy getStrategy();
    public A withStrategy(DeploymentStrategy strategy);
    public DeploymentSpecFluent.StrategyNested<A> withNewStrategy();
    public DeploymentSpecFluent.StrategyNested<A> withNewStrategyLike(DeploymentStrategy item);
    public DeploymentSpecFluent.StrategyNested<A> editStrategy();
    public DeploymentSpecFluent.StrategyNested<A> editOrNewStrategy();
    public DeploymentSpecFluent.StrategyNested<A> editOrNewStrategyLike(DeploymentStrategy item);
    public PodTemplateSpec getTemplate();
    public A withTemplate(PodTemplateSpec template);
    public DeploymentSpecFluent.TemplateNested<A> withNewTemplate();
    public DeploymentSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public DeploymentSpecFluent.TemplateNested<A> editTemplate();
    public DeploymentSpecFluent.TemplateNested<A> editOrNewTemplate();
    public DeploymentSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item);

    public interface RollbackToNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RollbackConfigFluent<DeploymentSpecFluent.RollbackToNested<N>>{

        
    public N and();    public N endRollbackTo();
}
    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluent<DeploymentSpecFluent.SelectorNested<N>>{

        
    public N and();    public N endSelector();
}
    public interface StrategyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentStrategyFluent<DeploymentSpecFluent.StrategyNested<N>>{

        
    public N and();    public N endStrategy();
}
    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateSpecFluent<DeploymentSpecFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}


}
