package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface SecurityContextFluent<A extends SecurityContextFluent<A>> extends Fluent<A>{


    public Capabilities getCapabilities();
    public A withCapabilities(Capabilities capabilities);
    public SecurityContextFluent.CapabilitiesNested<A> withNewCapabilities();
    public SecurityContextFluent.CapabilitiesNested<A> withNewCapabilitiesLike(Capabilities item);
    public SecurityContextFluent.CapabilitiesNested<A> editCapabilities();
    public SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilities();
    public SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilitiesLike(Capabilities item);
    public Boolean isPrivileged();
    public A withPrivileged(Boolean privileged);
    public Boolean isReadOnlyRootFilesystem();
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem);
    public Boolean isRunAsNonRoot();
    public A withRunAsNonRoot(Boolean runAsNonRoot);
    public Long getRunAsUser();
    public A withRunAsUser(Long runAsUser);
    public SELinuxOptions getSeLinuxOptions();
    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions);
    public SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions();
    public SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item);
    public SecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions();
    public SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions();
    public SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item);
    public A withNewSeLinuxOptions(String level,String role,String type,String user);

    public interface CapabilitiesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CapabilitiesFluent<SecurityContextFluent.CapabilitiesNested<N>>{

        
    public N and();    public N endCapabilities();
}
    public interface SeLinuxOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SELinuxOptionsFluent<SecurityContextFluent.SeLinuxOptionsNested<N>>{

        
    public N and();    public N endSeLinuxOptions();
}


}
