package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class ResourceQuotaSpecBuilder extends ResourceQuotaSpecFluentImpl<ResourceQuotaSpecBuilder> implements VisitableBuilder<ResourceQuotaSpec,ResourceQuotaSpecBuilder>{

    ResourceQuotaSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceQuotaSpecBuilder(){
            this(true);
    }
    public ResourceQuotaSpecBuilder(Boolean validationEnabled){
            this(new ResourceQuotaSpec(), validationEnabled);
    }
    public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ResourceQuotaSpec(), validationEnabled);
    }
    public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent,ResourceQuotaSpec instance){
            this(fluent, instance, true);
    }
    public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent,ResourceQuotaSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHard(instance.getHard()); 
            fluent.withScopes(instance.getScopes()); 
            this.validationEnabled = validationEnabled; 
    }
    public ResourceQuotaSpecBuilder(ResourceQuotaSpec instance){
            this(instance,true);
    }
    public ResourceQuotaSpecBuilder(ResourceQuotaSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHard(instance.getHard()); 
            this.withScopes(instance.getScopes()); 
            this.validationEnabled = validationEnabled; 
    }

    public ResourceQuotaSpec build(){
            ResourceQuotaSpec buildable = new ResourceQuotaSpec(fluent.getHard(),fluent.getScopes());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ResourceQuotaSpecBuilder that = (ResourceQuotaSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
