package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class DownwardAPIVolumeFileBuilder extends DownwardAPIVolumeFileFluentImpl<DownwardAPIVolumeFileBuilder> implements VisitableBuilder<DownwardAPIVolumeFile,DownwardAPIVolumeFileBuilder>{

    DownwardAPIVolumeFileFluent<?> fluent;
    Boolean validationEnabled;

    public DownwardAPIVolumeFileBuilder(){
            this(true);
    }
    public DownwardAPIVolumeFileBuilder(Boolean validationEnabled){
            this(new DownwardAPIVolumeFile(), validationEnabled);
    }
    public DownwardAPIVolumeFileBuilder(DownwardAPIVolumeFileFluent<?> fluent){
            this(fluent, true);
    }
    public DownwardAPIVolumeFileBuilder(DownwardAPIVolumeFileFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DownwardAPIVolumeFile(), validationEnabled);
    }
    public DownwardAPIVolumeFileBuilder(DownwardAPIVolumeFileFluent<?> fluent,DownwardAPIVolumeFile instance){
            this(fluent, instance, true);
    }
    public DownwardAPIVolumeFileBuilder(DownwardAPIVolumeFileFluent<?> fluent,DownwardAPIVolumeFile instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFieldRef(instance.getFieldRef()); 
            fluent.withPath(instance.getPath()); 
            fluent.withResourceFieldRef(instance.getResourceFieldRef()); 
            this.validationEnabled = validationEnabled; 
    }
    public DownwardAPIVolumeFileBuilder(DownwardAPIVolumeFile instance){
            this(instance,true);
    }
    public DownwardAPIVolumeFileBuilder(DownwardAPIVolumeFile instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFieldRef(instance.getFieldRef()); 
            this.withPath(instance.getPath()); 
            this.withResourceFieldRef(instance.getResourceFieldRef()); 
            this.validationEnabled = validationEnabled; 
    }

    public DownwardAPIVolumeFile build(){
            DownwardAPIVolumeFile buildable = new DownwardAPIVolumeFile(fluent.getFieldRef(),fluent.getPath(),fluent.getResourceFieldRef());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DownwardAPIVolumeFileBuilder that = (DownwardAPIVolumeFileBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
