package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class ContextBuilder extends ContextFluentImpl<ContextBuilder> implements VisitableBuilder<Context,ContextBuilder>{

    ContextFluent<?> fluent;
    Boolean validationEnabled;

    public ContextBuilder(){
            this(true);
    }
    public ContextBuilder(Boolean validationEnabled){
            this(new Context(), validationEnabled);
    }
    public ContextBuilder(ContextFluent<?> fluent){
            this(fluent, true);
    }
    public ContextBuilder(ContextFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Context(), validationEnabled);
    }
    public ContextBuilder(ContextFluent<?> fluent,Context instance){
            this(fluent, instance, true);
    }
    public ContextBuilder(ContextFluent<?> fluent,Context instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCluster(instance.getCluster()); 
            fluent.withExtensions(instance.getExtensions()); 
            fluent.withNamespace(instance.getNamespace()); 
            fluent.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }
    public ContextBuilder(Context instance){
            this(instance,true);
    }
    public ContextBuilder(Context instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCluster(instance.getCluster()); 
            this.withExtensions(instance.getExtensions()); 
            this.withNamespace(instance.getNamespace()); 
            this.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }

    public Context build(){
            Context buildable = new Context(fluent.getCluster(),fluent.getExtensions(),fluent.getNamespace(),fluent.getUser());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContextBuilder that = (ContextBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
