/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceFieldSelector;
import io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent;
import io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ResourceFieldSelectorBuilder
extends ResourceFieldSelectorFluentImpl<ResourceFieldSelectorBuilder>
implements VisitableBuilder<ResourceFieldSelector, ResourceFieldSelectorBuilder> {
    ResourceFieldSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceFieldSelectorBuilder() {
        this(true);
    }

    public ResourceFieldSelectorBuilder(Boolean validationEnabled) {
        this(new ResourceFieldSelector(), validationEnabled);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceFieldSelector(), validationEnabled);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent, ResourceFieldSelector instance) {
        this(fluent, instance, true);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent, ResourceFieldSelector instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withContainerName(instance.getContainerName());
        fluent.withDivisor(instance.getDivisor());
        fluent.withResource(instance.getResource());
        this.validationEnabled = validationEnabled;
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelector instance) {
        this(instance, (Boolean)true);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelector instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withContainerName(instance.getContainerName());
        this.withDivisor(instance.getDivisor());
        this.withResource(instance.getResource());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourceFieldSelector build() {
        ResourceFieldSelector buildable = new ResourceFieldSelector(this.fluent.getContainerName(), this.fluent.getDivisor(), this.fluent.getResource());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceFieldSelectorBuilder that = (ResourceFieldSelectorBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

