/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.CephFSVolumeSource;
import io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class CephFSVolumeSourceFluentImpl<A extends CephFSVolumeSourceFluent<A>>
extends BaseFluent<A>
implements CephFSVolumeSourceFluent<A> {
    private List<String> monitors = new ArrayList<String>();
    private String path;
    private Boolean readOnly;
    private String secretFile;
    private VisitableBuilder<? extends LocalObjectReference, ?> secretRef;
    private String user;

    public CephFSVolumeSourceFluentImpl() {
    }

    public CephFSVolumeSourceFluentImpl(CephFSVolumeSource instance) {
        this.withMonitors(instance.getMonitors());
        this.withPath(instance.getPath());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretFile(instance.getSecretFile());
        this.withSecretRef(instance.getSecretRef());
        this.withUser(instance.getUser());
    }

    @Override
    public A addToMonitors(String ... items) {
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMonitors(String ... items) {
        for (String item : items) {
            this.monitors.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMonitors() {
        return this.monitors;
    }

    @Override
    public A withMonitors(List<String> monitors) {
        this.monitors.clear();
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withMonitors(String ... monitors) {
        this.monitors.clear();
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (A)this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public String getSecretFile() {
        return this.secretFile;
    }

    @Override
    public A withSecretFile(String secretFile) {
        this.secretFile = secretFile;
        return (A)this;
    }

    @Override
    public LocalObjectReference getSecretRef() {
        return this.secretRef != null ? (LocalObjectReference)this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(LocalObjectReference secretRef) {
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public CephFSVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public CephFSVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public CephFSVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public A withNewSecretRef(String name) {
        return this.withSecretRef(new LocalObjectReference(name));
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CephFSVolumeSourceFluentImpl that = (CephFSVolumeSourceFluentImpl)o;
        if (this.monitors != null ? !this.monitors.equals(that.monitors) : that.monitors != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretFile != null ? !this.secretFile.equals(that.secretFile) : that.secretFile != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public class SecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<CephFSVolumeSourceFluent.SecretRefNested<N>>
    implements CephFSVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        SecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)CephFSVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }
    }
}

