package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class RouteStatusBuilder extends RouteStatusFluentImpl<RouteStatusBuilder> implements VisitableBuilder<RouteStatus,RouteStatusBuilder>{

    RouteStatusFluent<?> fluent;
    Boolean validationEnabled;

    public RouteStatusBuilder(){
            this(true);
    }
    public RouteStatusBuilder(Boolean validationEnabled){
            this(new RouteStatus(), validationEnabled);
    }
    public RouteStatusBuilder(RouteStatusFluent<?> fluent){
            this(fluent, true);
    }
    public RouteStatusBuilder(RouteStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RouteStatus(), validationEnabled);
    }
    public RouteStatusBuilder(RouteStatusFluent<?> fluent,RouteStatus instance){
            this(fluent, instance, true);
    }
    public RouteStatusBuilder(RouteStatusFluent<?> fluent,RouteStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withIngress(instance.getIngress()); 
            this.validationEnabled = validationEnabled; 
    }
    public RouteStatusBuilder(RouteStatus instance){
            this(instance,true);
    }
    public RouteStatusBuilder(RouteStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withIngress(instance.getIngress()); 
            this.validationEnabled = validationEnabled; 
    }

    public RouteStatus build(){
            RouteStatus buildable = new RouteStatus(fluent.getIngress());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteStatusBuilder that = (RouteStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
