package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface RouteListFluent<A extends RouteListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Route... items);
    public A removeFromItems(Route... items);
    public List<Route> getItems();
    public A withItems(List<Route> items);
    public A withItems(Route... items);
    public RouteListFluent.ItemsNested<A> addNewItem();
    public RouteListFluent.ItemsNested<A> addNewItemLike(Route item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public RouteListFluent.MetadataNested<A> withNewMetadata();
    public RouteListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public RouteListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,RouteFluent<RouteListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<RouteListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
