package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.List;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface PolicyBindingFluent<A extends PolicyBindingFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public String getLastModified();
    public A withLastModified(String lastModified);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public PolicyBindingFluent.MetadataNested<A> withNewMetadata();
    public PolicyBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PolicyBindingFluent.MetadataNested<A> editMetadata();
    public ObjectReference getPolicyRef();
    public A withPolicyRef(ObjectReference policyRef);
    public PolicyBindingFluent.PolicyRefNested<A> withNewPolicyRef();
    public PolicyBindingFluent.PolicyRefNested<A> withNewPolicyRefLike(ObjectReference item);
    public PolicyBindingFluent.PolicyRefNested<A> editPolicyRef();
    public A addToRoleBindings(NamedRoleBinding... items);
    public A removeFromRoleBindings(NamedRoleBinding... items);
    public List<NamedRoleBinding> getRoleBindings();
    public A withRoleBindings(List<NamedRoleBinding> roleBindings);
    public A withRoleBindings(NamedRoleBinding... roleBindings);
    public PolicyBindingFluent.RoleBindingsNested<A> addNewRoleBinding();
    public PolicyBindingFluent.RoleBindingsNested<A> addNewRoleBindingLike(NamedRoleBinding item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<PolicyBindingFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface PolicyRefNested<N> extends Nested<N>,ObjectReferenceFluent<PolicyBindingFluent.PolicyRefNested<N>>{

        
    public N endPolicyRef();    public N and();
}
    public interface RoleBindingsNested<N> extends Nested<N>,NamedRoleBindingFluent<PolicyBindingFluent.RoleBindingsNested<N>>{

        
    public N endRoleBinding();    public N and();
}


}
