package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface IngressTLSFluent<A extends IngressTLSFluent<A>> extends Fluent<A>{


    public A addToHosts(String... items);
    public A removeFromHosts(String... items);
    public List<String> getHosts();
    public A withHosts(List<String> hosts);
    public A withHosts(String... hosts);
    public String getSecretName();
    public A withSecretName(String secretName);



}
