package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class HorizontalPodAutoscalerSpecBuilder extends HorizontalPodAutoscalerSpecFluentImpl<HorizontalPodAutoscalerSpecBuilder> implements VisitableBuilder<HorizontalPodAutoscalerSpec,HorizontalPodAutoscalerSpecBuilder>{

    HorizontalPodAutoscalerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public HorizontalPodAutoscalerSpecBuilder(){
            this(true);
    }
    public HorizontalPodAutoscalerSpecBuilder(Boolean validationEnabled){
            this(new HorizontalPodAutoscalerSpec(), validationEnabled);
    }
    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent){
            this(fluent, true);
    }
    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HorizontalPodAutoscalerSpec(), validationEnabled);
    }
    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent,HorizontalPodAutoscalerSpec instance){
            this(fluent, instance, true);
    }
    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent,HorizontalPodAutoscalerSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCpuUtilization(instance.getCpuUtilization()); 
            fluent.withMaxReplicas(instance.getMaxReplicas()); 
            fluent.withMinReplicas(instance.getMinReplicas()); 
            fluent.withScaleRef(instance.getScaleRef()); 
            this.validationEnabled = validationEnabled; 
    }
    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpec instance){
            this(instance,true);
    }
    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCpuUtilization(instance.getCpuUtilization()); 
            this.withMaxReplicas(instance.getMaxReplicas()); 
            this.withMinReplicas(instance.getMinReplicas()); 
            this.withScaleRef(instance.getScaleRef()); 
            this.validationEnabled = validationEnabled; 
    }

    public HorizontalPodAutoscalerSpec build(){
            HorizontalPodAutoscalerSpec buildable = new HorizontalPodAutoscalerSpec(fluent.getCpuUtilization(),fluent.getMaxReplicas(),fluent.getMinReplicas(),fluent.getScaleRef());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HorizontalPodAutoscalerSpecBuilder that = (HorizontalPodAutoscalerSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
