package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface DaemonSetFluent<A extends DaemonSetFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public DaemonSetFluent.MetadataNested<A> withNewMetadata();
    public DaemonSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public DaemonSetFluent.MetadataNested<A> editMetadata();
    public DaemonSetSpec getSpec();
    public A withSpec(DaemonSetSpec spec);
    public DaemonSetFluent.SpecNested<A> withNewSpec();
    public DaemonSetFluent.SpecNested<A> withNewSpecLike(DaemonSetSpec item);
    public DaemonSetFluent.SpecNested<A> editSpec();
    public DaemonSetStatus getStatus();
    public A withStatus(DaemonSetStatus status);
    public DaemonSetFluent.StatusNested<A> withNewStatus();
    public DaemonSetFluent.StatusNested<A> withNewStatusLike(DaemonSetStatus item);
    public DaemonSetFluent.StatusNested<A> editStatus();
    public A withNewStatus(Integer currentNumberScheduled,Integer desiredNumberScheduled,Integer numberMisscheduled);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<DaemonSetFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,DaemonSetSpecFluent<DaemonSetFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,DaemonSetStatusFluent<DaemonSetFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
