package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Integer;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ProbeFluent<A extends ProbeFluent<A>> extends Fluent<A>{


    public ExecAction getExec();
    public A withExec(ExecAction exec);
    public ProbeFluent.ExecNested<A> withNewExec();
    public ProbeFluent.ExecNested<A> withNewExecLike(ExecAction item);
    public ProbeFluent.ExecNested<A> editExec();
    public Integer getFailureThreshold();
    public A withFailureThreshold(Integer failureThreshold);
    public HTTPGetAction getHttpGet();
    public A withHttpGet(HTTPGetAction httpGet);
    public ProbeFluent.HttpGetNested<A> withNewHttpGet();
    public ProbeFluent.HttpGetNested<A> withNewHttpGetLike(HTTPGetAction item);
    public ProbeFluent.HttpGetNested<A> editHttpGet();
    public Integer getInitialDelaySeconds();
    public A withInitialDelaySeconds(Integer initialDelaySeconds);
    public Integer getPeriodSeconds();
    public A withPeriodSeconds(Integer periodSeconds);
    public Integer getSuccessThreshold();
    public A withSuccessThreshold(Integer successThreshold);
    public TCPSocketAction getTcpSocket();
    public A withTcpSocket(TCPSocketAction tcpSocket);
    public ProbeFluent.TcpSocketNested<A> withNewTcpSocket();
    public ProbeFluent.TcpSocketNested<A> withNewTcpSocketLike(TCPSocketAction item);
    public ProbeFluent.TcpSocketNested<A> editTcpSocket();
    public Integer getTimeoutSeconds();
    public A withTimeoutSeconds(Integer timeoutSeconds);

    public interface ExecNested<N> extends Nested<N>,ExecActionFluent<ProbeFluent.ExecNested<N>>{

        
    public N and();    public N endExec();
}
    public interface HttpGetNested<N> extends Nested<N>,HTTPGetActionFluent<ProbeFluent.HttpGetNested<N>>{

        
    public N endHttpGet();    public N and();
}
    public interface TcpSocketNested<N> extends Nested<N>,TCPSocketActionFluent<ProbeFluent.TcpSocketNested<N>>{

        
    public N and();    public N endTcpSocket();
}


}
