package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class NodeSpecBuilder extends NodeSpecFluentImpl<NodeSpecBuilder> implements VisitableBuilder<NodeSpec,NodeSpecBuilder>{

    NodeSpecFluent<?> fluent;
    Boolean validationEnabled;

    public NodeSpecBuilder(){
            this(true);
    }
    public NodeSpecBuilder(Boolean validationEnabled){
            this(new NodeSpec(), validationEnabled);
    }
    public NodeSpecBuilder(NodeSpecFluent<?> fluent){
            this(fluent, true);
    }
    public NodeSpecBuilder(NodeSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NodeSpec(), validationEnabled);
    }
    public NodeSpecBuilder(NodeSpecFluent<?> fluent,NodeSpec instance){
            this(fluent, instance, true);
    }
    public NodeSpecBuilder(NodeSpecFluent<?> fluent,NodeSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withExternalID(instance.getExternalID()); 
            fluent.withPodCIDR(instance.getPodCIDR()); 
            fluent.withProviderID(instance.getProviderID()); 
            fluent.withUnschedulable(instance.getUnschedulable()); 
            this.validationEnabled = validationEnabled; 
    }
    public NodeSpecBuilder(NodeSpec instance){
            this(instance,true);
    }
    public NodeSpecBuilder(NodeSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withExternalID(instance.getExternalID()); 
            this.withPodCIDR(instance.getPodCIDR()); 
            this.withProviderID(instance.getProviderID()); 
            this.withUnschedulable(instance.getUnschedulable()); 
            this.validationEnabled = validationEnabled; 
    }

    public NodeSpec build(){
            NodeSpec buildable = new NodeSpec(fluent.getExternalID(),fluent.getPodCIDR(),fluent.getProviderID(),fluent.isUnschedulable());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NodeSpecBuilder that = (NodeSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
