package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Pattern;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class EnvVarFluentImpl<A extends EnvVarFluent<A>> extends BaseFluent<A> implements EnvVarFluent<A>{

    private String name;
    private String value;
    private VisitableBuilder<? extends EnvVarSource,?> valueFrom;

    public EnvVarFluentImpl(){
    }
    public EnvVarFluentImpl(EnvVar instance){
            this.withName(instance.getName()); 
            this.withValue(instance.getValue()); 
            this.withValueFrom(instance.getValueFrom()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public String getValue(){
            return this.value;
    }

    public A withValue(String value){
            this.value=value; return (A) this;
    }

    public EnvVarSource getValueFrom(){
            return this.valueFrom!=null?this.valueFrom.build():null;
    }

    public A withValueFrom(EnvVarSource valueFrom){
            if (valueFrom!=null){ this.valueFrom= new EnvVarSourceBuilder(valueFrom); _visitables.add(this.valueFrom);} return (A) this;
    }

    public EnvVarFluent.ValueFromNested<A> withNewValueFrom(){
            return new ValueFromNestedImpl();
    }

    public EnvVarFluent.ValueFromNested<A> withNewValueFromLike(EnvVarSource item){
            return new ValueFromNestedImpl(item);
    }

    public EnvVarFluent.ValueFromNested<A> editValueFrom(){
            return withNewValueFromLike(getValueFrom());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EnvVarFluentImpl that = (EnvVarFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (value != null ? !value.equals(that.value) :that.value != null) return false;
            if (valueFrom != null ? !valueFrom.equals(that.valueFrom) :that.valueFrom != null) return false;
            return true;
    }


    public class ValueFromNestedImpl<N> extends EnvVarSourceFluentImpl<EnvVarFluent.ValueFromNested<N>> implements EnvVarFluent.ValueFromNested<N>,Nested<N>{

            private final EnvVarSourceBuilder builder;
    
            ValueFromNestedImpl(EnvVarSource item){
                    this.builder = new EnvVarSourceBuilder(this, item);
            }
            ValueFromNestedImpl(){
                    this.builder = new EnvVarSourceBuilder(this);
            }
    
    public N endValueFrom(){
            return and();
    }
    public N and(){
            return (N) EnvVarFluentImpl.this.withValueFrom(builder.build());
    }

}


}
