package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class DeprecatedDownwardAPIVolumeFileFluentImpl<A extends DeprecatedDownwardAPIVolumeFileFluent<A>> extends BaseFluent<A> implements DeprecatedDownwardAPIVolumeFileFluent<A>{

    private VisitableBuilder<? extends ObjectFieldSelector,?> fieldRef;
    private String name;
    private VisitableBuilder<? extends ResourceFieldSelector,?> resourceFieldRef;

    public DeprecatedDownwardAPIVolumeFileFluentImpl(){
    }
    public DeprecatedDownwardAPIVolumeFileFluentImpl(DeprecatedDownwardAPIVolumeFile instance){
            this.withFieldRef(instance.getFieldRef()); 
            this.withName(instance.getName()); 
            this.withResourceFieldRef(instance.getResourceFieldRef()); 
    }

    public ObjectFieldSelector getFieldRef(){
            return this.fieldRef!=null?this.fieldRef.build():null;
    }

    public A withFieldRef(ObjectFieldSelector fieldRef){
            if (fieldRef!=null){ this.fieldRef= new ObjectFieldSelectorBuilder(fieldRef); _visitables.add(this.fieldRef);} return (A) this;
    }

    public DeprecatedDownwardAPIVolumeFileFluent.FieldRefNested<A> withNewFieldRef(){
            return new FieldRefNestedImpl();
    }

    public DeprecatedDownwardAPIVolumeFileFluent.FieldRefNested<A> withNewFieldRefLike(ObjectFieldSelector item){
            return new FieldRefNestedImpl(item);
    }

    public DeprecatedDownwardAPIVolumeFileFluent.FieldRefNested<A> editFieldRef(){
            return withNewFieldRefLike(getFieldRef());
    }

    public A withNewFieldRef(String apiVersion,String fieldPath){
            return (A)withFieldRef(new ObjectFieldSelector(apiVersion, fieldPath));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public ResourceFieldSelector getResourceFieldRef(){
            return this.resourceFieldRef!=null?this.resourceFieldRef.build():null;
    }

    public A withResourceFieldRef(ResourceFieldSelector resourceFieldRef){
            if (resourceFieldRef!=null){ this.resourceFieldRef= new ResourceFieldSelectorBuilder(resourceFieldRef); _visitables.add(this.resourceFieldRef);} return (A) this;
    }

    public DeprecatedDownwardAPIVolumeFileFluent.ResourceFieldRefNested<A> withNewResourceFieldRef(){
            return new ResourceFieldRefNestedImpl();
    }

    public DeprecatedDownwardAPIVolumeFileFluent.ResourceFieldRefNested<A> withNewResourceFieldRefLike(ResourceFieldSelector item){
            return new ResourceFieldRefNestedImpl(item);
    }

    public DeprecatedDownwardAPIVolumeFileFluent.ResourceFieldRefNested<A> editResourceFieldRef(){
            return withNewResourceFieldRefLike(getResourceFieldRef());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeprecatedDownwardAPIVolumeFileFluentImpl that = (DeprecatedDownwardAPIVolumeFileFluentImpl) o;
            if (fieldRef != null ? !fieldRef.equals(that.fieldRef) :that.fieldRef != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (resourceFieldRef != null ? !resourceFieldRef.equals(that.resourceFieldRef) :that.resourceFieldRef != null) return false;
            return true;
    }


    public class FieldRefNestedImpl<N> extends ObjectFieldSelectorFluentImpl<DeprecatedDownwardAPIVolumeFileFluent.FieldRefNested<N>> implements DeprecatedDownwardAPIVolumeFileFluent.FieldRefNested<N>,Nested<N>{

            private final ObjectFieldSelectorBuilder builder;
    
            FieldRefNestedImpl(){
                    this.builder = new ObjectFieldSelectorBuilder(this);
            }
            FieldRefNestedImpl(ObjectFieldSelector item){
                    this.builder = new ObjectFieldSelectorBuilder(this, item);
            }
    
    public N and(){
            return (N) DeprecatedDownwardAPIVolumeFileFluentImpl.this.withFieldRef(builder.build());
    }
    public N endFieldRef(){
            return and();
    }

}
    public class ResourceFieldRefNestedImpl<N> extends ResourceFieldSelectorFluentImpl<DeprecatedDownwardAPIVolumeFileFluent.ResourceFieldRefNested<N>> implements DeprecatedDownwardAPIVolumeFileFluent.ResourceFieldRefNested<N>,Nested<N>{

            private final ResourceFieldSelectorBuilder builder;
    
            ResourceFieldRefNestedImpl(){
                    this.builder = new ResourceFieldSelectorBuilder(this);
            }
            ResourceFieldRefNestedImpl(ResourceFieldSelector item){
                    this.builder = new ResourceFieldSelectorBuilder(this, item);
            }
    
    public N endResourceFieldRef(){
            return and();
    }
    public N and(){
            return (N) DeprecatedDownwardAPIVolumeFileFluentImpl.this.withResourceFieldRef(builder.build());
    }

}


}
