package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ConfigMapListFluent<A extends ConfigMapListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ConfigMap... items);
    public A removeFromItems(ConfigMap... items);
    public List<ConfigMap> getItems();
    public A withItems(List<ConfigMap> items);
    public A withItems(ConfigMap... items);
    public ConfigMapListFluent.ItemsNested<A> addNewItem();
    public ConfigMapListFluent.ItemsNested<A> addNewItemLike(ConfigMap item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ConfigMapListFluent.MetadataNested<A> withNewMetadata();
    public ConfigMapListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ConfigMapListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ConfigMapFluent<ConfigMapListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ConfigMapListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
