package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.IntOrString;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

public interface RoutePortFluent<A extends RoutePortFluent<A>> extends Fluent<A>{


    public IntOrString getTargetPort();
    public A withTargetPort(IntOrString targetPort);
    public RoutePortFluent.TargetPortNested<A> withNewTargetPort();
    public RoutePortFluent.TargetPortNested<A> withNewTargetPortLike(IntOrString item);
    public RoutePortFluent.TargetPortNested<A> editTargetPort();
    public A withNewTargetPort(String strVal);
    public A withNewTargetPort(Integer intVal);

    public interface TargetPortNested<N> extends Nested<N>,IntOrStringFluent<RoutePortFluent.TargetPortNested<N>>{

        
    public N endTargetPort();    public N and();
}


}
