package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface ProjectFluent<A extends ProjectFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ProjectFluent.MetadataNested<A> withNewMetadata();
    public ProjectFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ProjectFluent.MetadataNested<A> editMetadata();
    public ProjectSpec getSpec();
    public A withSpec(ProjectSpec spec);
    public ProjectFluent.SpecNested<A> withNewSpec();
    public ProjectFluent.SpecNested<A> withNewSpecLike(ProjectSpec item);
    public ProjectFluent.SpecNested<A> editSpec();
    public ProjectStatus getStatus();
    public A withStatus(ProjectStatus status);
    public ProjectFluent.StatusNested<A> withNewStatus();
    public ProjectFluent.StatusNested<A> withNewStatusLike(ProjectStatus item);
    public ProjectFluent.StatusNested<A> editStatus();
    public A withNewStatus(String phase);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ProjectFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,ProjectSpecFluent<ProjectFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,ProjectStatusFluent<ProjectFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
