package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface OAuthClientAuthorizationListFluent<A extends OAuthClientAuthorizationListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(OAuthClientAuthorization... items);
    public A removeFromItems(OAuthClientAuthorization... items);
    public List<OAuthClientAuthorization> getItems();
    public A withItems(List<OAuthClientAuthorization> items);
    public A withItems(OAuthClientAuthorization... items);
    public OAuthClientAuthorizationListFluent.ItemsNested<A> addNewItem();
    public OAuthClientAuthorizationListFluent.ItemsNested<A> addNewItemLike(OAuthClientAuthorization item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public OAuthClientAuthorizationListFluent.MetadataNested<A> withNewMetadata();
    public OAuthClientAuthorizationListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public OAuthClientAuthorizationListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,OAuthClientAuthorizationFluent<OAuthClientAuthorizationListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<OAuthClientAuthorizationListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
