package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.util.List;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface GroupFluent<A extends GroupFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public GroupFluent.MetadataNested<A> withNewMetadata();
    public GroupFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public GroupFluent.MetadataNested<A> editMetadata();
    public A addToUsers(String... items);
    public A removeFromUsers(String... items);
    public List<String> getUsers();
    public A withUsers(List<String> users);
    public A withUsers(String... users);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<GroupFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
