package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class ClusterRoleBindingFluentImpl<A extends ClusterRoleBindingFluent<A>> extends BaseFluent<A> implements ClusterRoleBindingFluent<A>{

    private String apiVersion;
    private List<String> groupNames = new ArrayList<String>();
    private String kind;
    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private VisitableBuilder<? extends ObjectReference,?> roleRef;
    private List<VisitableBuilder<? extends ObjectReference,?>> subjects =  new ArrayList<VisitableBuilder<? extends ObjectReference,?>>();
    private List<String> userNames = new ArrayList<String>();

    public ClusterRoleBindingFluentImpl(){
    }
    public ClusterRoleBindingFluentImpl(ClusterRoleBinding instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withGroupNames(instance.getGroupNames()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRoleRef(instance.getRoleRef()); 
            this.withSubjects(instance.getSubjects()); 
            this.withUserNames(instance.getUserNames()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToGroupNames(String... items){
            for (String item : items) {this.groupNames.add(item);} return (A)this;
    }

    public A removeFromGroupNames(String... items){
            for (String item : items) {this.groupNames.remove(item);} return (A)this;
    }

    public List<String> getGroupNames(){
            return this.groupNames;
    }

    public A withGroupNames(List<String> groupNames){
            this.groupNames.clear();
            if (groupNames != null) {for (String item : groupNames){this.addToGroupNames(item);}} return (A) this;
    }

    public A withGroupNames(String... groupNames){
            this.groupNames.clear(); if (groupNames != null) {for (String item :groupNames){ this.addToGroupNames(item);}} return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public ClusterRoleBindingFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ClusterRoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ClusterRoleBindingFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ObjectReference getRoleRef(){
            return this.roleRef!=null?this.roleRef.build():null;
    }

    public A withRoleRef(ObjectReference roleRef){
            if (roleRef!=null){ this.roleRef= new ObjectReferenceBuilder(roleRef); _visitables.add(this.roleRef);} return (A) this;
    }

    public ClusterRoleBindingFluent.RoleRefNested<A> withNewRoleRef(){
            return new RoleRefNestedImpl();
    }

    public ClusterRoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(ObjectReference item){
            return new RoleRefNestedImpl(item);
    }

    public ClusterRoleBindingFluent.RoleRefNested<A> editRoleRef(){
            return withNewRoleRefLike(getRoleRef());
    }

    public A addToSubjects(ObjectReference... items){
            for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.add(builder);this.subjects.add(builder);} return (A)this;
    }

    public A removeFromSubjects(ObjectReference... items){
            for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.remove(builder);this.subjects.remove(builder);} return (A)this;
    }

    public List<ObjectReference> getSubjects(){
            return build(subjects);
    }

    public A withSubjects(List<ObjectReference> subjects){
            this.subjects.clear();
            if (subjects != null) {for (ObjectReference item : subjects){this.addToSubjects(item);}} return (A) this;
    }

    public A withSubjects(ObjectReference... subjects){
            this.subjects.clear(); if (subjects != null) {for (ObjectReference item :subjects){ this.addToSubjects(item);}} return (A) this;
    }

    public ClusterRoleBindingFluent.SubjectsNested<A> addNewSubject(){
            return new SubjectsNestedImpl();
    }

    public ClusterRoleBindingFluent.SubjectsNested<A> addNewSubjectLike(ObjectReference item){
            return new SubjectsNestedImpl(item);
    }

    public A addToUserNames(String... items){
            for (String item : items) {this.userNames.add(item);} return (A)this;
    }

    public A removeFromUserNames(String... items){
            for (String item : items) {this.userNames.remove(item);} return (A)this;
    }

    public List<String> getUserNames(){
            return this.userNames;
    }

    public A withUserNames(List<String> userNames){
            this.userNames.clear();
            if (userNames != null) {for (String item : userNames){this.addToUserNames(item);}} return (A) this;
    }

    public A withUserNames(String... userNames){
            this.userNames.clear(); if (userNames != null) {for (String item :userNames){ this.addToUserNames(item);}} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterRoleBindingFluentImpl that = (ClusterRoleBindingFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (groupNames != null ? !groupNames.equals(that.groupNames) :that.groupNames != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (roleRef != null ? !roleRef.equals(that.roleRef) :that.roleRef != null) return false;
            if (subjects != null ? !subjects.equals(that.subjects) :that.subjects != null) return false;
            if (userNames != null ? !userNames.equals(that.userNames) :that.userNames != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ClusterRoleBindingFluent.MetadataNested<N>> implements ClusterRoleBindingFluent.MetadataNested<N>,Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ClusterRoleBindingFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class RoleRefNestedImpl<N> extends ObjectReferenceFluentImpl<ClusterRoleBindingFluent.RoleRefNested<N>> implements ClusterRoleBindingFluent.RoleRefNested<N>,Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            RoleRefNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
            RoleRefNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
    
    public N endRoleRef(){
            return and();
    }
    public N and(){
            return (N) ClusterRoleBindingFluentImpl.this.withRoleRef(builder.build());
    }

}
    public class SubjectsNestedImpl<N> extends ObjectReferenceFluentImpl<ClusterRoleBindingFluent.SubjectsNested<N>> implements ClusterRoleBindingFluent.SubjectsNested<N>,Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            SubjectsNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
            SubjectsNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
    
    public N and(){
            return (N) ClusterRoleBindingFluentImpl.this.addToSubjects(builder.build());
    }
    public N endSubject(){
            return and();
    }

}


}
