package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public class IngressListFluentImpl<A extends IngressListFluent<A>> extends BaseFluent<A> implements IngressListFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends Ingress,?>> items =  new ArrayList<VisitableBuilder<? extends Ingress,?>>();
    private String kind;
    private VisitableBuilder<? extends ListMeta,?> metadata;

    public IngressListFluentImpl(){
    }
    public IngressListFluentImpl(IngressList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToItems(Ingress... items){
            for (Ingress item : items) {IngressBuilder builder = new IngressBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(Ingress... items){
            for (Ingress item : items) {IngressBuilder builder = new IngressBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<Ingress> getItems(){
            return build(items);
    }

    public A withItems(List<Ingress> items){
            this.items.clear();
            if (items != null) {for (Ingress item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(Ingress... items){
            this.items.clear(); if (items != null) {for (Ingress item :items){ this.addToItems(item);}} return (A) this;
    }

    public IngressListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public IngressListFluent.ItemsNested<A> addNewItemLike(Ingress item){
            return new ItemsNestedImpl(item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public IngressListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public IngressListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public IngressListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IngressListFluentImpl that = (IngressListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends IngressFluentImpl<IngressListFluent.ItemsNested<N>> implements IngressListFluent.ItemsNested<N>,Nested<N>{

            private final IngressBuilder builder;
    
            ItemsNestedImpl(){
                    this.builder = new IngressBuilder(this);
            }
            ItemsNestedImpl(Ingress item){
                    this.builder = new IngressBuilder(this, item);
            }
    
    public N endItem(){
            return and();
    }
    public N and(){
            return (N) IngressListFluentImpl.this.addToItems(builder.build());
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<IngressListFluent.MetadataNested<N>> implements IngressListFluent.MetadataNested<N>,Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
    
    public N and(){
            return (N) IngressListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
