package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public class DeploymentSpecFluentImpl<A extends DeploymentSpecFluent<A>> extends BaseFluent<A> implements DeploymentSpecFluent<A>{

    private Integer minReadySeconds;
    private Boolean paused;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private VisitableBuilder<? extends RollbackConfig,?> rollbackTo;
    private VisitableBuilder<? extends LabelSelector,?> selector;
    private VisitableBuilder<? extends DeploymentStrategy,?> strategy;
    private VisitableBuilder<? extends PodTemplateSpec,?> template;

    public DeploymentSpecFluentImpl(){
    }
    public DeploymentSpecFluentImpl(DeploymentSpec instance){
            this.withMinReadySeconds(instance.getMinReadySeconds()); 
            this.withPaused(instance.getPaused()); 
            this.withReplicas(instance.getReplicas()); 
            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
            this.withRollbackTo(instance.getRollbackTo()); 
            this.withSelector(instance.getSelector()); 
            this.withStrategy(instance.getStrategy()); 
            this.withTemplate(instance.getTemplate()); 
    }

    public Integer getMinReadySeconds(){
            return this.minReadySeconds;
    }

    public A withMinReadySeconds(Integer minReadySeconds){
            this.minReadySeconds=minReadySeconds; return (A) this;
    }

    public Boolean isPaused(){
            return this.paused;
    }

    public A withPaused(Boolean paused){
            this.paused=paused; return (A) this;
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public Integer getRevisionHistoryLimit(){
            return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(Integer revisionHistoryLimit){
            this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
    }

    public RollbackConfig getRollbackTo(){
            return this.rollbackTo!=null?this.rollbackTo.build():null;
    }

    public A withRollbackTo(RollbackConfig rollbackTo){
            if (rollbackTo!=null){ this.rollbackTo= new RollbackConfigBuilder(rollbackTo); _visitables.add(this.rollbackTo);} return (A) this;
    }

    public DeploymentSpecFluent.RollbackToNested<A> withNewRollbackTo(){
            return new RollbackToNestedImpl();
    }

    public DeploymentSpecFluent.RollbackToNested<A> withNewRollbackToLike(RollbackConfig item){
            return new RollbackToNestedImpl(item);
    }

    public DeploymentSpecFluent.RollbackToNested<A> editRollbackTo(){
            return withNewRollbackToLike(getRollbackTo());
    }

    public A withNewRollbackTo(Long revision){
            return (A)withRollbackTo(new RollbackConfig(revision));
    }

    public LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(LabelSelector selector){
            if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.add(this.selector);} return (A) this;
    }

    public DeploymentSpecFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public DeploymentSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public DeploymentSpecFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public DeploymentStrategy getStrategy(){
            return this.strategy!=null?this.strategy.build():null;
    }

    public A withStrategy(DeploymentStrategy strategy){
            if (strategy!=null){ this.strategy= new DeploymentStrategyBuilder(strategy); _visitables.add(this.strategy);} return (A) this;
    }

    public DeploymentSpecFluent.StrategyNested<A> withNewStrategy(){
            return new StrategyNestedImpl();
    }

    public DeploymentSpecFluent.StrategyNested<A> withNewStrategyLike(DeploymentStrategy item){
            return new StrategyNestedImpl(item);
    }

    public DeploymentSpecFluent.StrategyNested<A> editStrategy(){
            return withNewStrategyLike(getStrategy());
    }

    public PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(PodTemplateSpec template){
            if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (A) this;
    }

    public DeploymentSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public DeploymentSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public DeploymentSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentSpecFluentImpl that = (DeploymentSpecFluentImpl) o;
            if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
            if (paused != null ? !paused.equals(that.paused) :that.paused != null) return false;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
            if (rollbackTo != null ? !rollbackTo.equals(that.rollbackTo) :that.rollbackTo != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class RollbackToNestedImpl<N> extends RollbackConfigFluentImpl<DeploymentSpecFluent.RollbackToNested<N>> implements DeploymentSpecFluent.RollbackToNested<N>,Nested<N>{

            private final RollbackConfigBuilder builder;
    
            RollbackToNestedImpl(){
                    this.builder = new RollbackConfigBuilder(this);
            }
            RollbackToNestedImpl(RollbackConfig item){
                    this.builder = new RollbackConfigBuilder(this, item);
            }
    
    public N endRollbackTo(){
            return and();
    }
    public N and(){
            return (N) DeploymentSpecFluentImpl.this.withRollbackTo(builder.build());
    }

}
    public class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<DeploymentSpecFluent.SelectorNested<N>> implements DeploymentSpecFluent.SelectorNested<N>,Nested<N>{

            private final LabelSelectorBuilder builder;
    
            SelectorNestedImpl(){
                    this.builder = new LabelSelectorBuilder(this);
            }
            SelectorNestedImpl(LabelSelector item){
                    this.builder = new LabelSelectorBuilder(this, item);
            }
    
    public N endSelector(){
            return and();
    }
    public N and(){
            return (N) DeploymentSpecFluentImpl.this.withSelector(builder.build());
    }

}
    public class StrategyNestedImpl<N> extends DeploymentStrategyFluentImpl<DeploymentSpecFluent.StrategyNested<N>> implements DeploymentSpecFluent.StrategyNested<N>,Nested<N>{

            private final DeploymentStrategyBuilder builder;
    
            StrategyNestedImpl(){
                    this.builder = new DeploymentStrategyBuilder(this);
            }
            StrategyNestedImpl(DeploymentStrategy item){
                    this.builder = new DeploymentStrategyBuilder(this, item);
            }
    
    public N endStrategy(){
            return and();
    }
    public N and(){
            return (N) DeploymentSpecFluentImpl.this.withStrategy(builder.build());
    }

}
    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<DeploymentSpecFluent.TemplateNested<N>> implements DeploymentSpecFluent.TemplateNested<N>,Nested<N>{

            private final PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(){
                    this.builder = new PodTemplateSpecBuilder(this);
            }
            TemplateNestedImpl(PodTemplateSpec item){
                    this.builder = new PodTemplateSpecBuilder(this, item);
            }
    
    public N endTemplate(){
            return and();
    }
    public N and(){
            return (N) DeploymentSpecFluentImpl.this.withTemplate(builder.build());
    }

}


}
