package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PersistentVolumeClaimListFluent<A extends PersistentVolumeClaimListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(PersistentVolumeClaim... items);
    public A removeFromItems(PersistentVolumeClaim... items);
    public List<PersistentVolumeClaim> getItems();
    public A withItems(List<PersistentVolumeClaim> items);
    public A withItems(PersistentVolumeClaim... items);
    public PersistentVolumeClaimListFluent.ItemsNested<A> addNewItem();
    public PersistentVolumeClaimListFluent.ItemsNested<A> addNewItemLike(PersistentVolumeClaim item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public PersistentVolumeClaimListFluent.MetadataNested<A> withNewMetadata();
    public PersistentVolumeClaimListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public PersistentVolumeClaimListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,PersistentVolumeClaimFluent<PersistentVolumeClaimListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<PersistentVolumeClaimListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
