package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class NamespaceFluentImpl<A extends NamespaceFluent<A>> extends BaseFluent<A> implements NamespaceFluent<A>{

    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private VisitableBuilder<? extends NamespaceSpec,?> spec;
    private VisitableBuilder<? extends NamespaceStatus,?> status;

    public NamespaceFluentImpl(){
    }
    public NamespaceFluentImpl(Namespace instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public NamespaceFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public NamespaceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public NamespaceFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public NamespaceSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(NamespaceSpec spec){
            if (spec!=null){ this.spec= new NamespaceSpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }

    public NamespaceFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public NamespaceFluent.SpecNested<A> withNewSpecLike(NamespaceSpec item){
            return new SpecNestedImpl(item);
    }

    public NamespaceFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public NamespaceStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(NamespaceStatus status){
            if (status!=null){ this.status= new NamespaceStatusBuilder(status); _visitables.add(this.status);} return (A) this;
    }

    public NamespaceFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public NamespaceFluent.StatusNested<A> withNewStatusLike(NamespaceStatus item){
            return new StatusNestedImpl(item);
    }

    public NamespaceFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public A withNewStatus(String phase){
            return (A)withStatus(new NamespaceStatus(phase));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamespaceFluentImpl that = (NamespaceFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<NamespaceFluent.MetadataNested<N>> implements NamespaceFluent.MetadataNested<N>,Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) NamespaceFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends NamespaceSpecFluentImpl<NamespaceFluent.SpecNested<N>> implements NamespaceFluent.SpecNested<N>,Nested<N>{

            private final NamespaceSpecBuilder builder;
    
            SpecNestedImpl(){
                    this.builder = new NamespaceSpecBuilder(this);
            }
            SpecNestedImpl(NamespaceSpec item){
                    this.builder = new NamespaceSpecBuilder(this, item);
            }
    
    public N endSpec(){
            return and();
    }
    public N and(){
            return (N) NamespaceFluentImpl.this.withSpec(builder.build());
    }

}
    public class StatusNestedImpl<N> extends NamespaceStatusFluentImpl<NamespaceFluent.StatusNested<N>> implements NamespaceFluent.StatusNested<N>,Nested<N>{

            private final NamespaceStatusBuilder builder;
    
            StatusNestedImpl(){
                    this.builder = new NamespaceStatusBuilder(this);
            }
            StatusNestedImpl(NamespaceStatus item){
                    this.builder = new NamespaceStatusBuilder(this, item);
            }
    
    public N and(){
            return (N) NamespaceFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
