package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;

public class IntOrStringFluentImpl<A extends IntOrStringFluent<A>> extends BaseFluent<A> implements IntOrStringFluent<A>{

    private Integer IntVal;
    private Integer Kind;
    private String StrVal;
    private Map<String,Object> additionalProperties = new LinkedHashMap<String,Object>();

    public IntOrStringFluentImpl(){
    }
    public IntOrStringFluentImpl(IntOrString instance){
            this.withIntVal(instance.getIntVal()); 
            this.withKind(instance.getKind()); 
            this.withStrVal(instance.getStrVal()); 
            this.withAdditionalProperties(instance.getAdditionalProperties()); 
            this.withIntVal(instance.getIntVal());

            this.withKind(instance.getKind());

            this.withStrVal(instance.getStrVal());

    }

    public Integer getIntVal(){
            return this.IntVal;
    }

    public A withIntVal(Integer IntVal){
            this.IntVal=IntVal; return (A) this;
    }

    public Integer getKind(){
            return this.Kind;
    }

    public A withKind(Integer Kind){
            this.Kind=Kind; return (A) this;
    }

    public String getStrVal(){
            return this.StrVal;
    }

    public A withStrVal(String StrVal){
            this.StrVal=StrVal; return (A) this;
    }

    public A addToAdditionalProperties(String key,Object value){
            if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
    }

    public A addToAdditionalProperties(Map<String,Object> map){
            if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
    }

    public A removeFromAdditionalProperties(String key){
            if(key != null) {this.additionalProperties.remove(key);} return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String,Object> map){
            if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (A)this;
    }

    public Map<String,Object> getAdditionalProperties(){
            return this.additionalProperties;
    }

    public A withAdditionalProperties(Map<String,Object> additionalProperties){
            this.additionalProperties.clear();
            if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IntOrStringFluentImpl that = (IntOrStringFluentImpl) o;
            if (IntVal != null ? !IntVal.equals(that.IntVal) :that.IntVal != null) return false;
            if (Kind != null ? !Kind.equals(that.Kind) :that.Kind != null) return false;
            if (StrVal != null ? !StrVal.equals(that.StrVal) :that.StrVal != null) return false;
            if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
            return true;
    }




}
