package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class ComponentStatusListFluentImpl<A extends ComponentStatusListFluent<A>> extends BaseFluent<A> implements ComponentStatusListFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends ComponentStatus,?>> items =  new ArrayList<VisitableBuilder<? extends ComponentStatus,?>>();
    private String kind;
    private VisitableBuilder<? extends ListMeta,?> metadata;

    public ComponentStatusListFluentImpl(){
    }
    public ComponentStatusListFluentImpl(ComponentStatusList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToItems(ComponentStatus... items){
            for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(ComponentStatus... items){
            for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<ComponentStatus> getItems(){
            return build(items);
    }

    public A withItems(List<ComponentStatus> items){
            this.items.clear();
            if (items != null) {for (ComponentStatus item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(ComponentStatus... items){
            this.items.clear(); if (items != null) {for (ComponentStatus item :items){ this.addToItems(item);}} return (A) this;
    }

    public ComponentStatusListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public ComponentStatusListFluent.ItemsNested<A> addNewItemLike(ComponentStatus item){
            return new ItemsNestedImpl(item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public ComponentStatusListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ComponentStatusListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public ComponentStatusListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ComponentStatusListFluentImpl that = (ComponentStatusListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends ComponentStatusFluentImpl<ComponentStatusListFluent.ItemsNested<N>> implements ComponentStatusListFluent.ItemsNested<N>,Nested<N>{

            private final ComponentStatusBuilder builder;
    
            ItemsNestedImpl(){
                    this.builder = new ComponentStatusBuilder(this);
            }
            ItemsNestedImpl(ComponentStatus item){
                    this.builder = new ComponentStatusBuilder(this, item);
            }
    
    public N endItem(){
            return and();
    }
    public N and(){
            return (N) ComponentStatusListFluentImpl.this.addToItems(builder.build());
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<ComponentStatusListFluent.MetadataNested<N>> implements ComponentStatusListFluent.MetadataNested<N>,Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
    
    public N and(){
            return (N) ComponentStatusListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
